/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.impl.element;

import de.linusdev.lutils.html.EditableHtmlElement;
import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeMap;
import de.linusdev.lutils.html.HtmlAttributeType;
import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectParser;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html._HtmlAddable;
import de.linusdev.lutils.html.builder.HtmlElementBuilder;
import de.linusdev.lutils.html.impl.HtmlText;
import de.linusdev.lutils.html.impl.StandardHtmlAttribute;
import de.linusdev.lutils.html.parser.AttrReaderState;
import de.linusdev.lutils.html.parser.AttributeReader;
import de.linusdev.lutils.html.parser.HtmlParserState;
import de.linusdev.lutils.html.parser.HtmlReader;
import de.linusdev.lutils.html.parser.HtmlWritingState;
import de.linusdev.lutils.html.parser.ParseException;
import de.linusdev.lutils.result.BiResult;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardHtmlElement
implements EditableHtmlElement {
    @NotNull
    protected final AbstractType<?> tag;
    @NotNull
    protected final @NotNull List<@NotNull HtmlObject> content;
    @NotNull
    protected final HtmlAttributeMap attributes;

    protected StandardHtmlElement(@NotNull AbstractType<?> tag, @NotNull @NotNull List<@NotNull HtmlObject> content, @NotNull HtmlAttributeMap attributes) {
        this.tag = tag;
        this.content = content;
        this.attributes = attributes;
    }

    @Override
    @NotNull
    public HtmlObjectType type() {
        return HtmlObjectType.ELEMENT;
    }

    @NotNull
    public AbstractType<?> tag() {
        return this.tag;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull HtmlObject> content() {
        return this.content;
    }

    @Override
    @NotNull
    public HtmlAttributeMap attributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public StandardHtmlElement copy() {
        HtmlElementBuilder builder = this.tag.builder();
        this.content.forEach(arg_0 -> StandardHtmlElement.lambda$copy$0((AbstractBuilder)builder, arg_0));
        this.attributes.forEach(arg_0 -> StandardHtmlElement.lambda$copy$1((AbstractBuilder)builder, arg_0));
        return ((AbstractBuilder)builder).build();
    }

    @Override
    public void write(@NotNull HtmlWritingState state, @NotNull Writer writer) throws IOException {
        writer.append("<").append(this.tag.name());
        for (HtmlAttribute attr : this.attributes) {
            writer.append(" ");
            attr.write(state, writer);
        }
        if (this.tag.isVoidElement()) {
            writer.append(">");
        } else if (this.content.isEmpty()) {
            writer.append(">");
            writer.append("</").append(this.tag.name()).append(">");
        } else {
            writer.append(">");
            if (!this.tag.isInline()) {
                state.addIndent();
            }
            for (HtmlObject obj : this.content) {
                if (!this.tag.isInline()) {
                    writer.append("\n").append(state.getIndent());
                }
                obj.write(state, writer);
            }
            if (!this.tag.isInline()) {
                state.removeIndent();
                writer.append("\n").append(state.getIndent());
            }
            writer.append("</").append(this.tag.name()).append(">");
        }
    }

    private static /* synthetic */ void lambda$copy$1(AbstractBuilder builder, HtmlAttribute attr) {
        builder.addAttribute(attr.copy());
    }

    private static /* synthetic */ void lambda$copy$0(AbstractBuilder builder, HtmlObject object) {
        builder.addContent(object.copy());
    }

    public static abstract class AbstractType<B extends AbstractBuilder<?>>
    implements HtmlElementType<B> {
        @NotNull
        private final String name;
        private final boolean inline;
        private final boolean voidElement;

        public AbstractType(@NotNull String name, boolean inline, boolean voidElement) {
            this.name = name;
            this.inline = inline;
            this.voidElement = voidElement;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        @Override
        @NotNull
        public abstract B builder();

        @Override
        @NotNull
        public HtmlObjectParser<? extends HtmlElement> parser() {
            return new Parser(this);
        }

        public boolean isInline() {
            return this.inline;
        }

        public boolean isVoidElement() {
            return this.voidElement;
        }

        public String toString() {
            return HtmlElementType.toString(this);
        }
    }

    public static class AbstractBuilder<SELF>
    implements HtmlElementBuilder,
    _HtmlAddable<SELF> {
        @NotNull
        protected final AbstractType<?> tag;
        @NotNull
        protected final @NotNull List<@NotNull HtmlObject> content;
        @NotNull
        protected final HtmlAttributeMap attributes;

        public AbstractBuilder(@NotNull AbstractType<?> tag) {
            this.tag = tag;
            this.content = new ArrayList<HtmlObject>();
            this.attributes = new HtmlAttributeMap();
        }

        public SELF addContent(@NotNull HtmlObject object) {
            if ((object = this.onContentAdd(object)) != null) {
                this.content.add(object);
            }
            return (SELF)this;
        }

        public <B extends HtmlElementBuilder> SELF addElement(@NotNull HtmlElementType<B> type, Consumer<B> adjuster) {
            B builder = type.builder();
            adjuster.accept(builder);
            this.addContent(builder.build());
            return (SELF)this;
        }

        public SELF addAttribute(@NotNull HtmlAttributeType<?> type, @Nullable String value) {
            HtmlAttribute attribute = this.onAttributeAdd(new StandardHtmlAttribute(type, value));
            if (attribute != null) {
                this.attributes.put(attribute);
            }
            return (SELF)this;
        }

        public SELF addAttribute(@NotNull HtmlAttribute attribute) {
            if ((attribute = this.onAttributeAdd(attribute)) != null) {
                this.attributes.put(attribute);
            }
            return (SELF)this;
        }

        public SELF addText(@NotNull String text) {
            this.addContent(new HtmlText(text));
            return (SELF)this;
        }

        @NotNull
        public HtmlAttributeMap getCurrentAttributes() {
            return this.attributes;
        }

        @Nullable
        protected HtmlObject onContentAdd(@NotNull HtmlObject object) {
            return object;
        }

        @Nullable
        protected HtmlAttribute onAttributeAdd(@NotNull HtmlAttribute attribute) {
            return attribute;
        }

        @Override
        @NotNull
        public StandardHtmlElement build() {
            return new StandardHtmlElement(this.tag, this.content, this.attributes);
        }

        @Override
        @ApiStatus.Internal
        public void _addContent(@NotNull HtmlObject object) {
            this.addContent(object);
        }
    }

    public static class Parser
    implements HtmlObjectParser<StandardHtmlElement> {
        @NotNull
        private final AbstractType<?> type;

        public Parser(@NotNull AbstractType<?> type) {
            this.type = type;
        }

        @Override
        @NotNull
        public StandardHtmlElement parse(@NotNull HtmlParserState state, @NotNull HtmlReader reader) throws IOException, ParseException {
            HtmlElementBuilder builder = this.type.builder();
            char c = reader.read();
            if (c != '<') {
                throw state.fail(c);
            }
            BiResult<String, Character> res = reader.readUntil(' ', '>');
            String tag = res.result1();
            if (tag.charAt(tag.length() - 1) == '/' && res.result2().charValue() == '>') {
                if (!tag.substring(0, tag.length() - 1).equals(this.type.name())) {
                    throw state.fail("Illegal tag name '" + tag + "'.");
                }
                return ((AbstractBuilder)builder).build();
            }
            if (!tag.equals(this.type.name())) {
                throw state.fail("Illegal tag name '" + tag + "'.");
            }
            if (res.result2().charValue() == ' ') {
                AttributeReader attrReader = reader.getAttributeReader(state);
                while (attrReader.state != AttrReaderState.TAG_END) {
                    HtmlAttributeType<?> attrType;
                    HtmlAttribute attribute;
                    String name = attrReader.readAttributeName();
                    if (attrReader.state == AttrReaderState.TAG_SELF_CLOSE) {
                        if (name != null && (attribute = state.onAttributeParsed(attrType = state.getRegistry().getAttributeTypeByName(name), null)) != null) {
                            ((AbstractBuilder)builder).addAttribute(attrType, null);
                        }
                        return ((AbstractBuilder)builder).build();
                    }
                    if (attrReader.state == AttrReaderState.ATTR_VALUE) {
                        String value = attrReader.readAttributeValue();
                        HtmlAttributeType<?> attrType2 = state.getRegistry().getAttributeTypeByName(name);
                        HtmlAttribute attribute2 = state.onAttributeParsed(attrType2, value);
                        if (attribute2 == null) continue;
                        ((AbstractBuilder)builder).addAttribute(attribute2);
                        continue;
                    }
                    if (name == null || (attribute = state.onAttributeParsed(attrType = state.getRegistry().getAttributeTypeByName(name), null)) == null) continue;
                    ((AbstractBuilder)builder).addAttribute(attribute);
                }
            }
            if (this.type.isVoidElement()) {
                return ((AbstractBuilder)builder).build();
            }
            int id = state.onStartParsingContent(this.type, ((AbstractBuilder)builder).getCurrentAttributes());
            while (true) {
                HtmlObject child;
                if ((c = reader.skipNewLinesAndFollowingSpaces()) == '<') {
                    c = reader.read();
                    if (c == '/') break;
                    reader.pushBack(c);
                    reader.pushBack('<');
                    child = state.onObjectParsed(state.getParser().parse(state, reader));
                    if (child == null) continue;
                    ((AbstractBuilder)builder).addContent(child);
                    continue;
                }
                reader.pushBack(c);
                child = state.onObjectParsed(state.getParser().parse(state, reader));
                if (child == null) continue;
                ((AbstractBuilder)builder).addContent(child);
            }
            state.onEndParsingContent(id);
            tag = reader.readUntil('>').trim();
            if (!tag.equals(this.type.name())) {
                throw state.fail("Illegal end tag name '" + tag + "', should be '" + this.type.name() + "'.");
            }
            return ((AbstractBuilder)builder).build();
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder(@NotNull Type tag) {
            super(tag);
        }
    }

    public static class CustomType<B extends AbstractBuilder<?>>
    extends AbstractType<B> {
        @NotNull
        protected final @NotNull Function<@NotNull CustomType<B>, @NotNull B> builder;

        public CustomType(@NotNull @NotNull Function<@NotNull CustomType<B>, @NotNull B> builder, @NotNull String name, boolean inline, boolean voidElement) {
            super(name, inline, voidElement);
            this.builder = builder;
        }

        @Override
        @NotNull
        public B builder() {
            return (B)((AbstractBuilder)this.builder.apply(this));
        }
    }

    public static class Type
    extends AbstractType<Builder> {
        @NotNull
        public static Type newNormal(@NotNull String name) {
            return new Type(name, false, false);
        }

        @NotNull
        public static Type newVoid(@NotNull String name) {
            return new Type(name, false, true);
        }

        @NotNull
        public static Type newInline(@NotNull String name) {
            return new Type(name, true, false);
        }

        @NotNull
        public static <B extends AbstractBuilder<?>> CustomType<B> newCustom(Function<@NotNull CustomType<B>, @NotNull B> builder, @NotNull String name) {
            return new CustomType<B>(builder, name, false, false);
        }

        @NotNull
        public static <B extends AbstractBuilder<B>> CustomType<B> newCustomInline(Function<@NotNull CustomType<B>, @NotNull B> builder, @NotNull String name) {
            return new CustomType<B>(builder, name, true, false);
        }

        @NotNull
        public static <B extends AbstractBuilder<B>> CustomType<B> newCustomVoid(Function<@NotNull CustomType<B>, @NotNull B> builder, @NotNull String name) {
            return new CustomType<B>(builder, name, false, true);
        }

        public Type(@NotNull String name, boolean inline, boolean voidElement) {
            super(name, inline, voidElement);
        }

        @Override
        @NotNull
        public Builder builder() {
            return new Builder(this);
        }
    }
}

