/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml;

import de.linusdev.lutils.html.HasHtmlContent;
import de.linusdev.lutils.html.HtmlAddable;
import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.impl.HtmlPage;
import de.linusdev.lutils.html.lhtml.LhtmlHead;
import de.linusdev.lutils.html.lhtml.LhtmlInjector;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholder;
import de.linusdev.lutils.html.lhtml.LhtmlTemplate;
import de.linusdev.lutils.html.lhtml.LhtmlTemplateElement;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlPageSkeleton;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlTemplateSkeleton;
import de.linusdev.lutils.html.parser.HtmlParser;
import de.linusdev.lutils.html.parser.HtmlParserState;
import de.linusdev.lutils.html.parser.HtmlReader;
import de.linusdev.lutils.html.parser.HtmlWritingState;
import de.linusdev.lutils.html.parser.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LhtmlPage
implements HtmlObject,
HasHtmlContent,
LhtmlTemplate {
    @NotNull
    public static final String ID = "page";
    @NotNull
    protected final HtmlPage actual;
    @NotNull
    protected final Map<String, LhtmlPlaceholder> placeholders;
    @NotNull
    protected final Map<String, LhtmlTemplateSkeleton> templates;
    @NotNull
    protected final Map<String, String> replaceValues;
    @NotNull
    protected final LhtmlHead head;
    @NotNull
    protected final HtmlElement body;

    @NotNull
    public static LhtmlPageSkeleton parse(@NotNull HtmlParser parser, @NotNull Reader reader) throws IOException, ParseException {
        LhtmlInjector injector = new LhtmlInjector();
        HtmlParserState state = new HtmlParserState(injector, parser);
        HtmlReader htmlReader = new HtmlReader(reader);
        HtmlPage page = HtmlPage.PARSER.parse(state, htmlReader);
        return injector.getBuilder().buildPage(page);
    }

    public LhtmlPage(@NotNull HtmlPage actual, @NotNull Map<String, LhtmlPlaceholder> placeholders, @NotNull Map<String, LhtmlTemplateSkeleton> templates, @NotNull Map<String, String> replaceValues, @NotNull LhtmlHead head, @NotNull HtmlElement body) {
        this.actual = actual;
        this.placeholders = placeholders;
        this.templates = templates;
        this.replaceValues = replaceValues;
        this.head = head;
        this.body = body;
    }

    @NotNull
    public LhtmlHead getHead() {
        return this.head;
    }

    @NotNull
    public HtmlElement getBody() {
        return this.body;
    }

    public void addPageContentToPlaceholder(@NotNull String id, @NotNull LhtmlPage other) {
        HtmlAddable placeholder = this.getPlaceholder(id);
        for (HtmlObject object : other.getBody().content()) {
            placeholder.addContent(object);
        }
        this.getHead().addLinks(other.getHead());
    }

    @Override
    @NotNull
    public HtmlAddable getPlaceholder(@NotNull String id) {
        return Objects.requireNonNull(this.placeholders.get(id), "No template found with id '" + id + "'.");
    }

    @Override
    public void setValue(@NotNull String key, @NotNull String value) {
        this.replaceValues.put(key, value);
    }

    @Override
    @NotNull
    public LhtmlTemplateElement getTemplate(@NotNull String id) {
        return Objects.requireNonNull(this.templates.get(id)).copy();
    }

    @Override
    @NotNull
    public HtmlObjectType type() {
        return HtmlObjectType.PAGE;
    }

    @Override
    @NotNull
    public LhtmlPage copy() {
        return LhtmlPageSkeleton.createCopy(this.actual, this.templates);
    }

    @Override
    public void write(@NotNull HtmlWritingState state, @NotNull Writer writer) throws IOException {
        this.actual.write(state, writer);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull HtmlObject> content() {
        return this.actual.content();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

