/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image;

import org.jetbrains.annotations.NotNull;

public abstract class PixelFormat<V> {
    public static final PixelFormat<Integer> R8G8B8A8_SRGB = new PixelFormat<Integer>("R8G8B8A8_SRGB"){

        @Override
        public <U> Integer from(@NotNull PixelFormat<U> other, U value) {
            return other.toR8G8B8A8_SRGB(value);
        }

        @Override
        public int toR8G8B8A8_SRGB(Integer value) {
            return value;
        }

        @Override
        public int toA8R8G8B8_SRGB(Integer value) {
            int alpha = (value & 0xFF) << 24;
            return value >>> 8 | alpha;
        }
    };
    public static final PixelFormat<Integer> A8R8G8B8_SRGB = new PixelFormat<Integer>("A8R8G8B8_SRGB"){

        @Override
        public <U> Integer from(@NotNull PixelFormat<U> other, U value) {
            return other.toA8R8G8B8_SRGB(value);
        }

        @Override
        public int toR8G8B8A8_SRGB(Integer value) {
            int alpha = (value & 0xFF000000) >>> 24;
            return value << 8 | alpha;
        }

        @Override
        public int toA8R8G8B8_SRGB(Integer value) {
            return value;
        }
    };
    @NotNull
    protected final String name;

    protected PixelFormat(@NotNull String name) {
        this.name = name;
    }

    public abstract <U> V from(@NotNull PixelFormat<U> var1, U var2);

    public abstract int toR8G8B8A8_SRGB(V var1);

    public int toA8R8G8B8_SRGB(V value) {
        return R8G8B8A8_SRGB.toA8R8G8B8_SRGB(this.toR8G8B8A8_SRGB(value));
    }

    public String toString() {
        return this.name;
    }
}

