/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.atlas;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.atlas.AtlasImage;
import de.linusdev.lutils.image.atlas.ImageRef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Atlas<T extends Image, ID>
implements Image,
Iterable<AtlasImage<ID>> {
    @NotNull
    private final T backingImage;
    @NotNull
    private final @NotNull List<@NotNull AtlasImage<ID>> images;

    public Atlas(@NotNull T backingImage, int imgCount) {
        this.backingImage = backingImage;
        this.images = new ArrayList<AtlasImage<ID>>(imgCount);
    }

    void addImage(@NotNull ImageRef<ID> ref, int offsetX, int offsetY) {
        double uvXStart = (double)offsetX / (double)this.getWidth();
        double uvYStart = (double)offsetY / (double)this.getHeight();
        double uvXEnd = uvXStart + (double)ref.getWidth() / (double)this.getWidth();
        double uvYEnd = uvYStart + (double)ref.getHeight() / (double)this.getHeight();
        AtlasImage<ID> added = new AtlasImage<ID>(this, ref.getId(), ref.isRotated(), ref.isRotated() ? uvYStart : uvXStart, ref.isRotated() ? uvXStart : uvYStart, ref.isRotated() ? uvYEnd : uvXEnd, ref.isRotated() ? uvXEnd : uvYEnd, offsetX, offsetY, ref.getWidth(), ref.getHeight());
        this.images.add(added);
        ref.onAddedToAtlas(added);
    }

    @Override
    public int getPixelAsRGBA(int x, int y) {
        return this.backingImage.getPixelAsRGBA(x, y);
    }

    @Override
    public void setPixelAsRGBA(int x, int y, int rgba) {
        this.backingImage.setPixelAsRGBA(x, y, rgba);
    }

    @Override
    public boolean isReadOnly() {
        return this.backingImage.isReadOnly();
    }

    @Override
    public int getWidth() {
        return this.backingImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.backingImage.getHeight();
    }

    @NotNull
    public T getBackingImage() {
        return this.backingImage;
    }

    @Override
    @NotNull
    public Iterator<AtlasImage<ID>> iterator() {
        return this.images.iterator();
    }
}

