/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.atlas;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.ImageSize;
import de.linusdev.lutils.image.ImageSupplier;
import de.linusdev.lutils.image.atlas.Atlas;
import de.linusdev.lutils.image.atlas.ImageRef;
import de.linusdev.lutils.image.atlas.Row;
import de.linusdev.lutils.math.LMath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AtlasBuilder<ID> {
    @NotNull
    public final List<ImageRef<ID>> sizes;

    public AtlasBuilder(int expectedImageCount) {
        this.sizes = new ArrayList<ImageRef<ID>>(expectedImageCount);
    }

    public void add(@NotNull ImageRef<ID> ref) {
        this.sizes.add(ref);
    }

    @NotNull
    private ImageSize calcExpectedImageSize() {
        int sumWidth = 0;
        int sumHeight = 0;
        for (ImageSize imageSize : this.sizes) {
            sumWidth += imageSize.getWidth();
            sumHeight += imageSize.getHeight();
        }
        int avgWidth = sumWidth / this.sizes.size();
        double d = Math.ceil(Math.sqrt(this.sizes.size()));
        int expectedWidth = (int)((double)avgWidth * d);
        double denominator = LMath.interpolate(4.0, 1000.0, 2.0, 20.0, this.sizes.size());
        expectedWidth += (int)((double)expectedWidth / denominator);
        return ImageSize.of(expectedWidth, sumHeight);
    }

    @NotNull
    public <T extends Image> Atlas<T, ID> build(@NotNull ImageSupplier<T> supplier) throws IOException {
        this.sizes.sort(Comparator.comparingInt(ImageSize::getArea).reversed());
        ImageSize expectedImageSize = this.calcExpectedImageSize();
        Row mainRow = new Row(expectedImageSize.getWidth(), expectedImageSize.getHeight());
        for (ImageRef<ID> ref : this.sizes) {
            if (ref.getHeight() > ref.getWidth()) {
                ref.rotate();
            }
            if (mainRow.add(ref, true)) continue;
            throw new Error();
        }
        T image = supplier.supply(mainRow.getCurrentWidth(), mainRow.getCurrentHeight());
        Atlas atlas = new Atlas(image, this.sizes.size());
        mainRow.fillAtlas(atlas, 0, 0);
        return atlas;
    }
}

