/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.atlas;

import de.linusdev.lutils.image.atlas.Atlas;
import de.linusdev.lutils.image.atlas.ImageRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Row<ID> {
    @Nullable
    private final Row<ID> parentRow;
    private final int height;
    private int currentYOffset = 0;
    @NotNull
    private final @NotNull List<@NotNull Row<ID>> subRows = new ArrayList<Row<ID>>();
    @Nullable
    private Row<ID> largestSubRow;
    private int minWidth = 0;
    private int currentMaxWidth;
    private int currentXOffset = 0;
    @NotNull
    private final @NotNull List<@NotNull ImageRef<ID>> images = new ArrayList<ImageRef<ID>>();

    public Row(int maxWidth, int height) {
        this.parentRow = null;
        this.height = height;
        this.currentMaxWidth = maxWidth;
    }

    public Row(@Nullable Row<ID> parentRow, int currentMaxWidth, @NotNull ImageRef<ID> firstImage) {
        this.parentRow = parentRow;
        this.height = firstImage.getHeight();
        this.currentMaxWidth = currentMaxWidth;
        this.add(firstImage, true);
    }

    protected void addToMinWidth(int add) {
        int oldMinWidth = this.minWidth;
        this.minWidth += add;
        if (this.parentRow != null) {
            this.parentRow.onSubRowWidthUpdated(this, oldMinWidth);
        }
    }

    protected void addToCurrentXOffset(int add) {
        this.currentXOffset += add;
        for (Row<ID> subRow : this.subRows) {
            subRow.updateCurrentMaxWidth(this.currentMaxWidth - this.currentXOffset);
        }
    }

    protected void onSubRowWidthUpdated(@NotNull Row<ID> subRow, int oldMinWidth) {
        if (subRow == this.largestSubRow) {
            this.addToMinWidth(subRow.minWidth - oldMinWidth);
        } else if (this.largestSubRow == null) {
            this.largestSubRow = subRow;
            this.addToMinWidth(subRow.minWidth);
        } else if (this.largestSubRow.minWidth < subRow.minWidth) {
            this.addToMinWidth(subRow.minWidth - this.largestSubRow.minWidth);
            this.largestSubRow = subRow;
        }
    }

    protected void updateCurrentMaxWidth(int newMaxWidth) {
        this.currentMaxWidth = newMaxWidth;
        for (Row<ID> subRow : this.subRows) {
            subRow.updateCurrentMaxWidth(this.currentMaxWidth - this.currentXOffset);
        }
    }

    protected boolean addSubRow(@NotNull ImageRef<ID> image) {
        if (this.currentYOffset + image.getHeight() > this.height) {
            return false;
        }
        if (image.getWidth() > this.currentMaxWidth - this.currentXOffset) {
            return false;
        }
        this.currentYOffset += image.getHeight();
        this.subRows.add(new Row<ID>(this, this.currentMaxWidth - this.currentXOffset, image));
        return true;
    }

    public boolean add(@NotNull ImageRef<ID> image, boolean tryRotate) {
        if (image.getHeight() > this.height) {
            if (!tryRotate || image.getHeight() == image.getWidth()) {
                return false;
            }
            image.rotate();
            if (this.add(image, false)) {
                return true;
            }
            image.rotate();
            return false;
        }
        if (image.getHeight() < this.height) {
            for (Row<ID> subRow : this.subRows) {
                if (!subRow.add(image, true)) continue;
                return true;
            }
            return this.addSubRow(image);
        }
        if (this.minWidth + image.getWidth() > this.currentMaxWidth) {
            return false;
        }
        this.images.add(image);
        this.addToCurrentXOffset(image.getWidth());
        this.addToMinWidth(image.getWidth());
        return true;
    }

    public void fillAtlas(@NotNull Atlas<?, ID> atlas, int offsetX, int offsetY) throws IOException {
        int x = offsetX;
        int y = offsetY;
        for (ImageRef<ID> imageRef : this.images) {
            imageRef.storeTo(atlas, x, y);
            x += imageRef.getWidth();
        }
        for (Row row : this.subRows) {
            row.fillAtlas(atlas, x, y);
            y += row.height;
        }
    }

    public int getCurrentHeight() {
        return this.images.isEmpty() ? this.currentYOffset : this.height;
    }

    public int getCurrentWidth() {
        return this.minWidth;
    }
}

