/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.wip_webp.reader.simple.lossless;

import de.linusdev.lutils.image.wip_webp.reader.BitReader;
import de.linusdev.lutils.image.wip_webp.reader.WebPImageInfo;
import de.linusdev.lutils.image.wip_webp.reader.WebPReaderException;
import de.linusdev.lutils.image.wip_webp.reader.simple.lossless.TransformType;
import de.linusdev.lutils.image.wip_webp.reader.simple.lossless.transforms.PredictorTypeTransform;
import org.jetbrains.annotations.NotNull;

public class SimpleLosslessWebP {
    public static void read(@NotNull BitReader reader) throws WebPReaderException {
        if (reader.readByte() != 47) {
            throw new WebPReaderException("1-byte signature 0x2f missing in RIFF header");
        }
        int imageWidth = reader.readBitsToInt(14) + 1;
        int imageHeight = reader.readBitsToInt(14) + 1;
        boolean alphaIsUsed = reader.readBitsToInt(1) == 1;
        int versionNumber = reader.readBitsToInt(3);
        @NotNull WebPImageInfo info = new WebPImageInfo(imageWidth, imageHeight, alphaIsUsed, versionNumber);
        while (reader.readBitsToInt(1) == 1) {
            TransformType type = TransformType.of(reader.readBitsToInt(2));
            switch (type) {
                case PREDICTOR_TRANSFORM: {
                    PredictorTypeTransform.read(reader, info);
                    break;
                }
                case COLOR_TRANSFORM: {
                    break;
                }
                case SUBTRACT_GREEN_TRANSFORM: {
                    break;
                }
            }
        }
    }
}

