/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.array.NativeArray;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLengthOption=RequirementType.REQUIRED, customLayoutOption=RequirementType.OPTIONAL)
public abstract class NativePrimitiveTypeArray<T>
extends Structure
implements NativeArray<T> {
    protected ArrayInfo.ArrayPositionFunction positions;

    protected NativePrimitiveTypeArray(@Nullable StructValue structValue, boolean generateInfo, @NotNull StaticGenerator generator) {
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, generator));
        }
    }

    @Override
    public int length() {
        return this.getInfo().getLength();
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        this.positions = this.getInfo().getPositions();
    }

    @Override
    @NotNull
    public ArrayInfo getInfo() {
        return (ArrayInfo)super.getInfo();
    }

    @NotNull
    public ArrayInfo.ArrayPositionFunction getPositions() {
        if (this.positions == null) {
            throw new IllegalStateException("Cannot get positions function, because this struct has not yet been allocated or claimed a buffer.");
        }
        return this.positions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("length=").append(this.length()).append("\n");
        sb.append("items={");
        for (Object t : this) {
            sb.append(t.toString()).append(", ");
        }
        sb.append("}");
        return this.toString(this.getClass().getSimpleName(), sb.toString());
    }

    public static class PrimitiveArrayStaticGenerator
    implements StaticGenerator {
        private final NativeType nativeType;

        public PrimitiveArrayStaticGenerator(NativeType nativeType) {
            this.nativeType = nativeType;
        }

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
            assert (structValue != null);
            return abi.calculateArrayLayout(false, this.nativeType.getMemorySizeable(abi.types()), structValue.length()[0], -1);
        }
    }
}

