/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.memory;

import de.linusdev.lutils.nat.NativeParsable;
import org.jetbrains.annotations.NotNull;

public interface DirectMemoryManager
extends NativeParsable {
    public long memorySize();

    public long usedByteCount();

    default public long freeByteCount() {
        return this.memorySize() - this.usedByteCount();
    }

    default public double usedBytesPercentage() {
        return (double)this.usedByteCount() / (double)this.freeByteCount();
    }

    public int currentStructCount();

    @NotNull
    default public String info() {
        return String.format("%s { used:%.3f%% (%d bytes), structs: %d }", this.getClass().getSimpleName(), this.usedBytesPercentage(), this.usedByteCount(), this.currentStructCount());
    }

    default public boolean isAddressInside(long address) {
        if ((address -= this.getPointer()) < 0L) {
            return false;
        }
        return address < this.memorySize();
    }
}

