/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.abstracts;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.Language;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.generator.StructCodeGenerator;
import de.linusdev.lutils.nat.struct.info.ComplexStructureInfo;
import de.linusdev.lutils.nat.struct.info.StructVarInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.mod.ModTrackingStructure;
import de.linusdev.lutils.nat.struct.utils.ClassAndAbi;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import de.linusdev.lutils.nat.struct.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLayoutOption=RequirementType.OPTIONAL)
public abstract class ComplexStructure
extends ModTrackingStructure {
    @NotNull
    public static final StaticGenerator GENERATOR = new ComplexStructureGenerator();
    protected Structure[] items;

    public ComplexStructure(boolean trackModifications) {
        super(trackModifications);
    }

    protected void init(@Nullable StructValue structValue, boolean generateInfo, Structure ... items) {
        if (items.length != 0) {
            this.items = items;
        }
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, GENERATOR));
        }
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        if (this.items == null) {
            return;
        }
        ComplexStructureInfo cInfo = this.getInfo();
        StructVarInfo[] childrenInfos = cInfo.getChildrenInfo();
        int[] sizes = cInfo.getSizes();
        int position = 0;
        for (int i = 0; i < this.items.length; ++i) {
            position += sizes[i * 2];
            if (this.items[i] != null) {
                this.items[i].useBuffer(mostParentStructure, offset + position, childrenInfos[i].getInfo());
            }
            position += sizes[i * 2 + 1];
        }
    }

    @Override
    @NotNull
    public ComplexStructureInfo getInfo() {
        return (ComplexStructureInfo)super.getInfo();
    }

    @Override
    protected void onSetInfo(@NotNull StructureInfo info) {
        super.onSetInfo(info);
        if (this.items == null) {
            this.items = this.getInfo().getChildren(this);
        }
    }

    @Override
    @Nullable
    protected StructureInfo generateInfo() {
        return SSMUtils.getInfo(this.getClass(), null, null, null, null, null, GENERATOR);
    }

    public String toString() {
        ComplexStructureInfo cInfo = this.getInfo();
        StringBuilder sb = new StringBuilder();
        int @NotNull [] sizes = cInfo.getSizes();
        @NotNull StructVarInfo @NotNull [] childrenInfo = cInfo.getChildrenInfo();
        for (int i = 0; i < sizes.length; ++i) {
            String text;
            if (sizes[i] == 0) continue;
            if ((i - 1) % 2 == 0) {
                StructVarInfo childInfo = childrenInfo[(i - 1) / 2];
                text = childInfo.getVarName() + ": " + childInfo.get(this).toString() + "\n";
            } else {
                text = "padding: { size=" + sizes[i] + " }\n";
            }
            sb.append(Utils.indent(text, "    ")).append("\n");
        }
        return this.toString(GENERATOR.codeGenerator().getStructTypeName(Language.OPEN_CL, this.getClass(), cInfo), sb.toString());
    }

    private static class ComplexStructureGenerator
    implements StaticGenerator {
        @NotNull
        private final Map<ClassAndAbi, ComplexStructureInfo> INFO_MAP = new HashMap<ClassAndAbi, ComplexStructureInfo>();
        @NotNull
        private final Object INFO_MAP_LOCK = new Object();

        private ComplexStructureGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
            Object object = this.INFO_MAP_LOCK;
            synchronized (object) {
                ClassAndAbi key = new ClassAndAbi(selfClazz, abi);
                ComplexStructureInfo info = this.INFO_MAP.get(key);
                if (info == null) {
                    info = ComplexStructureInfo.generateFromStructVars(selfClazz, abi, overwriteChildAbi);
                    this.INFO_MAP.put(key, info);
                }
                return info;
            }
        }

        @Override
        @NotNull
        public StructCodeGenerator codeGenerator() {
            return new StructCodeGenerator(){

                @Override
                @NotNull
                public String generateStructCode(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
                    ComplexStructureInfo cInfo = (ComplexStructureInfo)info;
                    StringBuilder sb = new StringBuilder();
                    int @NotNull [] sizes = cInfo.getSizes();
                    @NotNull StructVarInfo @NotNull [] childrenInfo = cInfo.getChildrenInfo();
                    int paddingIndex = 0;
                    sb.append(language.getStartStructString(true, this.getStructTypeName(language, selfClazz, info)));
                    for (int i = 0; i < sizes.length; ++i) {
                        String text;
                        if (sizes[i] == 0) continue;
                        if ((i - 1) % 2 == 0) {
                            StructVarInfo childInfo = childrenInfo[(i - 1) / 2];
                            StaticGenerator childGenerator = SSMUtils.getGenerator(childInfo.getClazz(), null);
                            text = childGenerator.codeGenerator().getStructVarDef(language, childInfo.getClazz(), childInfo.getInfo(), childInfo.getVarName());
                        } else {
                            StringBuilder pad = new StringBuilder();
                            paddingIndex = language.addPadding(pad, sizes[i], paddingIndex);
                            text = pad.toString();
                        }
                        sb.append(Utils.indent(text, "    ")).append("\n");
                    }
                    sb.append(language.getEndStructString(true, this.getStructTypeName(language, selfClazz, info)));
                    return sb.toString();
                }

                @Override
                @NotNull
                public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
                    String name = selfClazz.getSimpleName();
                    if (name.endsWith("Struct")) {
                        name = name.substring(0, name.length() - "Struct".length());
                    }
                    if (name.endsWith("Structure")) {
                        name = name.substring(0, name.length() - "Structure".length());
                    }
                    return name;
                }
            };
        }
    }
}

