/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.abstracts;

import de.linusdev.lutils.nat.NativeParsable;
import de.linusdev.lutils.nat.struct.annos.StructureLayoutSettings;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.Language;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.BufferUtils;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import de.linusdev.lutils.nat.struct.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureLayoutSettings
@StructureSettings
public abstract class Structure
implements NativeParsable {
    protected Structure mostParentStructure;
    private StructureInfo info;
    protected ByteBuffer byteBuf;
    protected int offset;
    protected volatile boolean modified;

    @NotNull
    public static <S extends Structure> S allocate(@NotNull S structure) {
        structure.allocate();
        return structure;
    }

    @NotNull
    public static <S extends Structure> S unionWith(@NotNull S view, @NotNull Structure actual) {
        view.useBuffer(actual.getMostParentStructure(), actual.getOffset(), view.isInfoAvailable());
        return view;
    }

    @Deprecated
    @NotNull
    public static String generateStructCode(@NotNull Language language, @NotNull Class<? extends Structure> structClass) {
        StaticGenerator generator = SSMUtils.getGenerator(structClass, null);
        StructureInfo info = SSMUtils.getInfo(structClass, null, null, null, null, null, generator);
        String code = generator.codeGenerator().generateStructCode(language, structClass, info);
        if (code == null) {
            throw new IllegalArgumentException("Structure '" + structClass.getCanonicalName() + "' cannot generate struct code.");
        }
        return code;
    }

    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        this.setInfo(info);
        this.mostParentStructure = mostParentStructure;
        this.offset = offset;
        this.byteBuf = offset == 0 ? mostParentStructure.getByteBuffer().order(ByteOrder.nativeOrder()) : mostParentStructure.getByteBuffer().slice(offset, this.getRequiredSize()).order(ByteOrder.nativeOrder());
    }

    protected void callUseBufferOf(@NotNull Structure structure, @NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        structure.useBuffer(mostParentStructure, offset, info);
    }

    public void claimBuffer(@NotNull ByteBuffer buffer) {
        this.byteBuf = buffer.order(ByteOrder.nativeOrder());
        this.useBuffer(this, 0, this.isInfoAvailable());
    }

    public void allocate() {
        this.setInfo(this.isInfoAvailable());
        this.claimBuffer(BufferUtils.create64BitAligned(this.getRequiredSize()));
    }

    @NotNull
    protected StructureInfo isInfoAvailable() {
        StructureInfo rInfo = this.info;
        if (rInfo == null && (rInfo = this.generateInfo()) == null) {
            throw new IllegalStateException("This structure cannot claim a buffer in it's current state.");
        }
        return rInfo;
    }

    @Nullable
    protected StructureInfo generateInfo() {
        return null;
    }

    @NotNull
    public StructureInfo getInfo() {
        if (this.info == null) {
            throw new IllegalStateException("Info is not yet available. allocate or useBuffer must be called first.");
        }
        return this.info;
    }

    @NotNull
    public StructureInfo getOrGenerateInfo() {
        this.setInfo(this.isInfoAvailable());
        return this.getInfo();
    }

    protected final void setInfo(@NotNull StructureInfo info) {
        if (this.info == info) {
            return;
        }
        this.info = info;
        this.onSetInfo(info);
    }

    protected void onSetInfo(@NotNull StructureInfo info) {
    }

    @Override
    public int getAlignment() {
        return this.getInfo().getAlignment();
    }

    @Override
    public int getRequiredSize() {
        return this.getInfo().getRequiredSize();
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    @Override
    public boolean isInitialised() {
        return this.byteBuf != null;
    }

    protected String toString(@NotNull String name, @Nullable String content) {
        return String.format("%s (alignment=%d, size=%d, offsetStart=%d, offsetEnd=%d) %s", name, this.getAlignment(), this.getRequiredSize(), this.getOffset(), this.getOffset() + this.getRequiredSize(), content == null ? "" : "{\n" + Utils.indent(content, "    ") + "\n}");
    }

    public void modified(int offset, int size) {
        this.mostParentStructure.onModification(offset, size);
    }

    public void modified() {
        this.modified(this.offset, this.getRequiredSize());
    }

    public void unmodified() {
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void onModification(int offset, int size) {
        this.modified = true;
    }

    public Structure getMostParentStructure() {
        return this.mostParentStructure;
    }
}

