/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.mod;

import org.jetbrains.annotations.Nullable;

public class ModificationInfo {
    public volatile int startOffset;
    public volatile int endOffset;
    public volatile ModificationInfo next = null;
    public volatile ModificationInfo previous = null;

    public ModificationInfo(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Nullable
    public ModificationInfo add(int startOffset, int endOffset, int split, @Nullable ModificationInfo checked) {
        if (endOffset + split < this.startOffset) {
            if (this.previous == null) {
                this.previous = new ModificationInfo(startOffset, endOffset);
                this.previous.next = this;
                return this.previous;
            }
            if (this.previous == checked) {
                assert (checked != null);
                checked.next = this.previous = new ModificationInfo(startOffset, endOffset);
                this.previous.next = this;
                this.previous.previous = checked;
                return this.previous;
            }
            return this.previous.add(startOffset, endOffset, split, this);
        }
        if (startOffset - split > this.endOffset) {
            if (this.next == null) {
                this.next = new ModificationInfo(startOffset, endOffset);
                this.next.previous = this;
                return this.next;
            }
            if (this.next == checked) {
                assert (checked != null);
                checked.previous = this.next = new ModificationInfo(startOffset, endOffset);
                this.next.previous = this;
                this.next.next = checked;
                return this.next;
            }
            return this.next.add(startOffset, endOffset, split, this);
        }
        this.startOffset = Math.min(startOffset, this.startOffset);
        this.endOffset = Math.max(endOffset, this.endOffset);
        if (this.previous != null && this.previous.endOffset + split < this.startOffset) {
            this.startOffset = this.previous.startOffset;
            this.previous = this.previous.previous;
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        if (this.next != null && this.endOffset + split > this.next.startOffset) {
            this.endOffset = this.next.endOffset;
            this.next = this.next.next;
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return null;
    }

    public String toString() {
        return "ModificationInfo[startOffset=" + this.startOffset + " endOffset=" + this.endOffset + " hasNext=" + (this.next != null) + "]";
    }
}

