/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http;

import de.linusdev.lutils.net.http.body.Body;
import de.linusdev.lutils.net.http.header.Header;
import de.linusdev.lutils.net.http.header.HeaderMap;
import de.linusdev.lutils.net.http.header.HeaderName;
import de.linusdev.lutils.net.http.header.value.HeaderValue;
import de.linusdev.lutils.net.http.method.Methods;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.http.status.ResponseStatusCode;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.http.version.HTTPVersion;
import de.linusdev.lutils.net.http.version.HTTPVersions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPMessageBuilder {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte[] LINE_SEPARATOR = "\r\n".getBytes(CHARSET);
    public static final byte SPACE = 32;
    @NotNull
    private RequestMethod method;
    @Nullable
    private String path;
    @NotNull
    private HTTPVersion version;
    @NotNull
    private ResponseStatusCode statusCode;
    @NotNull
    private HeaderMap headers = new HeaderMap();
    @Nullable
    private Body body;

    public HTTPMessageBuilder() {
        this.version = HTTPVersions.HTTP_1_1;
        this.method = Methods.GET;
        this.statusCode = StatusCodes.OK;
    }

    public HTTPMessageBuilder setMethod(@NotNull RequestMethod method) {
        this.method = method;
        return this;
    }

    public HTTPMessageBuilder setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public HTTPMessageBuilder setVersion(@NotNull HTTPVersion version) {
        this.version = version;
        return this;
    }

    public HTTPMessageBuilder setStatusCode(@NotNull ResponseStatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HTTPMessageBuilder setBody(@Nullable Body body) {
        if (this.body != null) {
            this.body.removeHeaders(this.headers);
        }
        this.body = body;
        if (this.body != null) {
            this.body.adjustHeaders(this.headers);
        }
        return this;
    }

    public HTTPMessageBuilder setHeader(@NotNull String key, @Nullable String value) {
        if (value == null) {
            this.headers.remove(key);
        } else {
            this.headers.put(key, Header.of(key, value));
        }
        return this;
    }

    public HTTPMessageBuilder setHeader(@NotNull Header header) {
        this.headers.put(header);
        return this;
    }

    public HTTPMessageBuilder setHeader(@NotNull HeaderName name, @Nullable String value) {
        if (value == null) {
            this.headers.remove(name.getName());
        } else {
            this.headers.put(name.with(value));
        }
        return this;
    }

    public HTTPMessageBuilder setHeader(@NotNull HeaderName name, @Nullable HeaderValue value) {
        if (value == null) {
            this.headers.remove(name.getName());
        } else {
            this.headers.put(name.with(value));
        }
        return this;
    }

    public HTTPMessageBuilder setHeaders(@NotNull HeaderMap headers) {
        this.headers = headers;
        return this;
    }

    public HTTPMessageBuilder GET(@Nullable String path) {
        this.setMethod(Methods.GET);
        this.setPath(path);
        return this;
    }

    public HTTPMessageBuilder POST(@Nullable String path, @NotNull Body body) {
        this.setMethod(Methods.POST);
        this.setPath(path);
        this.setBody(body);
        return this;
    }

    public String buildRequest() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.buildRequest(stream);
        return stream.toString(StandardCharsets.UTF_8);
    }

    public String buildResponse() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.buildResponse(stream);
        return stream.toString(StandardCharsets.UTF_8);
    }

    public void buildRequest(@NotNull OutputStream stream) throws IOException {
        this.buildRequest(stream, 2048);
    }

    public void buildResponse(@NotNull OutputStream stream) throws IOException {
        this.buildResponse(stream, 2048);
    }

    public void buildRequest(@NotNull OutputStream stream, int maxBufferSize) throws IOException {
        stream.write(this.method.getName().getBytes(CHARSET));
        stream.write(32);
        if (this.path != null) {
            stream.write(this.path.getBytes(CHARSET));
            stream.write(32);
        }
        stream.write(this.version.asString().getBytes(CHARSET));
        stream.write(LINE_SEPARATOR);
        this.appendHeaderAndBody(stream, maxBufferSize);
    }

    public void buildResponse(@NotNull OutputStream stream, int maxBufferSize) throws IOException {
        stream.write(this.version.asString().getBytes(CHARSET));
        stream.write(32);
        stream.write(Objects.toString(this.statusCode.getStatusCode()).getBytes(CHARSET));
        stream.write(32);
        stream.write(this.statusCode.getName().getBytes(CHARSET));
        stream.write(LINE_SEPARATOR);
        this.appendHeaderAndBody(stream, maxBufferSize);
    }

    private void appendHeaderAndBody(@NotNull OutputStream stream, int maxBufferSize) throws IOException {
        for (Header header : this.headers.values()) {
            stream.write(header.asString().getBytes(CHARSET));
            stream.write(LINE_SEPARATOR);
        }
        stream.write(LINE_SEPARATOR);
        if (this.body != null) {
            byte[] buffer = this.body.length() == -1L ? new byte[maxBufferSize] : new byte[(int)Math.min(this.body.length(), (long)maxBufferSize)];
            try (InputStream bodyStream = this.body.stream();){
                int len;
                while ((len = bodyStream.read(buffer)) != -1) {
                    stream.write(buffer, 0, len);
                }
            }
        }
    }
}

