/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.body;

import de.linusdev.lutils.interfaces.TSupplier;
import de.linusdev.lutils.interfaces.Writable;
import de.linusdev.lutils.io.ResourceUtils;
import de.linusdev.lutils.net.http.body.Body;
import de.linusdev.lutils.net.http.header.contenttype.ContentType;
import de.linusdev.lutils.net.http.header.contenttype.ContentTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bodies {
    @NotNull
    public static Creator html() {
        return new Creator(ContentTypes.Text.html());
    }

    @NotNull
    public static Creator css() {
        return new Creator(ContentTypes.Text.css());
    }

    @NotNull
    public static Creator javascript() {
        return new Creator(ContentTypes.Text.js());
    }

    @NotNull
    public static Creator textUtf8() {
        return new Creator(ContentTypes.Text.plain().setCharset(StandardCharsets.UTF_8.name()));
    }

    @NotNull
    public static Creator png() {
        return new Creator(ContentTypes.Image.png());
    }

    public static class Creator {
        @NotNull
        private final ContentType contentType;

        public Creator(@NotNull ContentType contentType) {
            this.contentType = contentType;
        }

        @NotNull
        public Body ofResource(@Nullable Class<?> relClazz, @NotNull String path) {
            return new StreamURLConnectionBody(ResourceUtils.getURLConnectionOfResource(relClazz, path), this.contentType);
        }

        @NotNull
        public Body ofResource(@NotNull String path) {
            return this.ofResource(null, path);
        }

        @NotNull
        public Body ofRegularFile(@NotNull Path pathToFile) {
            if (!Files.isRegularFile(pathToFile, new LinkOption[0])) {
                throw new IllegalArgumentException("'" + pathToFile + "' is not a regular file.");
            }
            try {
                return new InputStreamSupplierBody(() -> Files.newInputStream(pathToFile, StandardOpenOption.READ), this.contentType, Files.size(pathToFile));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read file size of file'" + pathToFile + "'", e);
            }
        }

        @NotNull
        public Body ofStringUtf8(@NotNull String string) {
            return new ByteArrayBody(string.getBytes(StandardCharsets.UTF_8), this.contentType);
        }

        @NotNull
        public Body ofWritable(@NotNull Writable writable) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                writable.write(out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new ByteArrayBody(out.toByteArray(), this.contentType);
        }
    }

    private record ByteArrayBody(byte @NotNull [] bytes, @NotNull ContentType contentType) implements Body
    {
        @Override
        public long length() {
            return this.bytes.length;
        }

        @Override
        @NotNull
        public InputStream stream() {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private record StreamURLConnectionBody(@NotNull ResourceUtils.StreamURLConnection connection, @NotNull ContentType contentType) implements Body
    {
        @Override
        public long length() {
            return this.connection.getContentLength();
        }

        @Override
        @NotNull
        public InputStream stream() throws IOException {
            return this.connection.openInputStream();
        }
    }

    private record InputStreamSupplierBody(@NotNull TSupplier<InputStream, IOException> supplier, @NotNull ContentType contentType, long contentLength) implements Body
    {
        @Override
        public long length() {
            return this.contentLength;
        }

        @Override
        @NotNull
        public InputStream stream() throws IOException {
            return this.supplier.supply();
        }
    }
}

