/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.header;

import de.linusdev.lutils.net.http.header.HeaderImpl;
import de.linusdev.lutils.net.http.header.value.HeaderValueParser;
import org.jetbrains.annotations.NotNull;

public interface Header {
    @NotNull
    public static Header of(@NotNull String header) {
        int sep = header.indexOf(58);
        return new HeaderImpl(header.substring(0, sep), header.substring(sep + 2));
    }

    @NotNull
    public static Header of(@NotNull String key, @NotNull String value) {
        return new HeaderImpl(key, value);
    }

    @NotNull
    public String getKey();

    @NotNull
    public String getValue();

    @NotNull
    default public <T> T parseValue(@NotNull HeaderValueParser<T> parser) {
        return parser.parse(this);
    }

    @NotNull
    default public String asString() {
        return this.getKey() + ": " + this.getValue();
    }

    public static boolean equals(Header header, Object other) {
        if (header == other) {
            return true;
        }
        if (!(other instanceof Header)) {
            return false;
        }
        Header otherHeader = (Header)other;
        return header.getKey().equalsIgnoreCase(otherHeader.getKey()) && header.getValue().equalsIgnoreCase(otherHeader.getValue());
    }

    public static int hashCode(Header header) {
        int result = header.getKey().toLowerCase().hashCode();
        result = 31 * result + header.getValue().toLowerCase().hashCode();
        return result;
    }
}

