/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing;

import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.routing.RequestHandler;
import de.linusdev.lutils.net.routing.RoutingState;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Route {
    @NotNull
    protected final HashMap<String, Route> routes;
    @Nullable
    protected final Route defaultRoute;
    @NotNull
    protected final Map<RequestMethod, RequestHandler> handlers;
    @Nullable
    private final RequestHandler defaultHandler;

    public Route(@Nullable Route defaultRoute, @NotNull HashMap<String, Route> routes, @NotNull Map<RequestMethod, RequestHandler> handlers, @Nullable RequestHandler defaultHandler) {
        this.defaultRoute = defaultRoute;
        this.routes = routes;
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
    }

    public Route(boolean defaultRouteIsSelf, @NotNull HashMap<String, Route> routes, @NotNull Map<RequestMethod, RequestHandler> handlers, @Nullable RequestHandler defaultHandler) {
        this.defaultRoute = defaultRouteIsSelf ? this : null;
        this.routes = routes;
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
    }

    @Nullable
    public HTTPMessageBuilder accept(@NotNull RoutingState state) throws IOException {
        if (state.isHandled()) {
            return null;
        }
        if (state.isAnotherPathPartAvailable()) {
            return this.fallBackToDefaultRouteIfNull(this.route(state), state);
        }
        RequestHandler handler = this.handlers.get(state.getMethod());
        if (handler == null) {
            return this.fallBackToDefaultHandler(state);
        }
        HTTPMessageBuilder response = handler.handle(state);
        if (response == null) {
            return this.fallBackToDefaultHandler(state);
        }
        return response;
    }

    @Nullable
    private HTTPMessageBuilder fallBackToDefaultRouteIfNull(@Nullable HTTPMessageBuilder response, @NotNull RoutingState state) throws IOException {
        if (response == null) {
            if (this.defaultRoute == null) {
                return null;
            }
            return this.defaultRoute.accept(state);
        }
        return response;
    }

    @Nullable
    private HTTPMessageBuilder fallBackToDefaultHandler(@NotNull RoutingState state) throws IOException {
        if (this.defaultHandler == null) {
            return null;
        }
        return this.defaultHandler.handle(state);
    }

    @Nullable
    private HTTPMessageBuilder route(@NotNull RoutingState state) throws IOException {
        Route route = this.routes.get(state.getNextPathPart());
        if (route == null) {
            return null;
        }
        return route.accept(state);
    }
}

