/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing;

import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPRequest;
import de.linusdev.lutils.net.http.HTTPResponse;
import de.linusdev.lutils.net.http.body.BodyParsers;
import de.linusdev.lutils.net.http.body.UnparsedBody;
import de.linusdev.lutils.net.http.method.RequestMethod;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.routing.RequestHandler;
import de.linusdev.lutils.net.routing.Route;
import de.linusdev.lutils.net.routing.RoutingState;
import de.linusdev.lutils.net.routing.builder.RoutingBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Routing
extends Route {
    @NotNull
    private final String prefix;
    @NotNull
    private final String prefixNoEndSlash;
    @NotNull
    private final @NotNull Function<@NotNull Throwable, @Nullable HTTPMessageBuilder> exceptionHandler;

    @NotNull
    public static RoutingBuilder builder() {
        return new RoutingBuilder();
    }

    public Routing(@NotNull String prefix, @NotNull Route defaultRoute, @NotNull HashMap<String, Route> routes, @NotNull @NotNull Function<@NotNull Throwable, @Nullable HTTPMessageBuilder> exceptionHandler) {
        super(defaultRoute, routes, new HashMap<RequestMethod, RequestHandler>(0), null);
        this.prefix = prefix;
        this.prefixNoEndSlash = prefix.substring(0, prefix.length() - 1);
        this.exceptionHandler = exceptionHandler;
    }

    public void route(@NotNull Socket socket) throws IOException {
        HTTPMessageBuilder response = this.route(socket, socket.getInputStream());
        if (response != null) {
            response.buildResponse(socket.getOutputStream());
            socket.close();
        }
    }

    @Nullable
    public HTTPMessageBuilder route(@NotNull HTTPRequest<UnparsedBody> request) {
        return this.route(null, request);
    }

    @Nullable
    private HTTPMessageBuilder route(@Nullable Socket socket, @NotNull InputStream stream) {
        try {
            return this.route(socket, HTTPRequest.parse(stream, BodyParsers.newUnparsedBodyParser()));
        }
        catch (Throwable t) {
            HTTPMessageBuilder response = this.exceptionHandler.apply(t);
            return response == null ? HTTPResponse.builder().setStatusCode(StatusCodes.INTERNAL_SERVER_ERROR) : response;
        }
    }

    @Nullable
    private HTTPMessageBuilder route(@Nullable Socket socket, @NotNull HTTPRequest<UnparsedBody> request) {
        Object path;
        Object object = path = request.getPathAndQuery() == null ? "/" : request.getPathAndQuery().getPath();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!(((String)path).startsWith(this.prefix) || ((String)path).startsWith(this.prefixNoEndSlash) && ((String)path).length() == this.prefixNoEndSlash.length())) {
            return HTTPResponse.builder().setStatusCode(StatusCodes.BAD_REQUEST);
        }
        path = ((String)path).substring(this.prefixNoEndSlash.length());
        try {
            RoutingState state = new RoutingState(socket, request, (String)path);
            HTTPMessageBuilder response = this.accept(state);
            if (response == null && !state.isHandled()) {
                return HTTPResponse.builder().setStatusCode(StatusCodes.INTERNAL_SERVER_ERROR);
            }
            return response;
        }
        catch (Throwable t) {
            HTTPMessageBuilder response = this.exceptionHandler.apply(t);
            return response == null ? HTTPResponse.builder().setStatusCode(StatusCodes.INTERNAL_SERVER_ERROR) : response;
        }
    }
}

