/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.routing.builder;

import de.linusdev.lutils.net.http.HTTPMessageBuilder;
import de.linusdev.lutils.net.http.HTTPResponse;
import de.linusdev.lutils.net.http.status.StatusCodes;
import de.linusdev.lutils.net.routing.Route;
import de.linusdev.lutils.net.routing.Routing;
import de.linusdev.lutils.net.routing.builder.RouteBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutingBuilder {
    @NotNull
    private final HashMap<String, RouteBuilder<?>> routes = new HashMap();
    @NotNull
    private RouteBuilder<RoutingBuilder> defaultRoute;
    @NotNull
    private String prefix = "/";
    @NotNull
    private @NotNull Function<@NotNull Throwable, @Nullable HTTPMessageBuilder> exceptionHandler = t -> null;

    public RoutingBuilder() {
        this.defaultRoute = this.defaultRoute().defaultHandler(request -> HTTPResponse.builder().setStatusCode(StatusCodes.NOT_FOUND));
    }

    @NotNull
    public RouteBuilder<RoutingBuilder> route(@NotNull String path) {
        RouteBuilder<RoutingBuilder> builder = new RouteBuilder<RoutingBuilder>(this, this);
        this.routes.put(path, builder);
        return builder;
    }

    @NotNull
    public RouteBuilder<RoutingBuilder> defaultRoute() {
        this.defaultRoute = new RouteBuilder<RoutingBuilder>(this, this);
        this.defaultRoute.setDefaultRouteIsSelf(true);
        return this.defaultRoute;
    }

    public RoutingBuilder setPrefix(@NotNull String prefix) {
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.prefix = prefix;
        return this;
    }

    public RoutingBuilder setExceptionHandler(@NotNull @NotNull Function<@NotNull Throwable, @Nullable HTTPMessageBuilder> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @NotNull
    public Routing build() {
        HashMap<String, Route> routes = new HashMap<String, Route>(this.routes.size());
        for (Map.Entry<String, RouteBuilder<?>> route : this.routes.entrySet()) {
            routes.put(route.getKey(), route.getValue().getRoute());
        }
        return new Routing(this.prefix, this.defaultRoute.getRoute(), routes, this.exceptionHandler);
    }
}

