/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws;

import de.linusdev.lutils.net.ws.WebSocket;
import de.linusdev.lutils.net.ws.control.CloseFrame;
import de.linusdev.lutils.net.ws.control.writable.WritableCloseFrame;
import de.linusdev.lutils.net.ws.frame.Frame;
import de.linusdev.lutils.net.ws.frame.OpCodes;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class WebSocketListener {
    @NotNull
    private static final AtomicInteger ID_SUPPLIER = new AtomicInteger(0);
    private final int id = ID_SUPPLIER.incrementAndGet();

    public WebSocketListener(@NotNull WebSocket webSocket, @NotNull Listener listener) {
        new Thread(() -> {
            while (!webSocket.isClosed()) {
                try {
                    Frame frame = webSocket.readFrame();
                    if (frame.opcode() == OpCodes.CLOSE) {
                        listener.onClose(webSocket, frame.toCloseFrame());
                        continue;
                    }
                    listener.onReceived(webSocket, frame);
                }
                catch (IOException e) {
                    if (webSocket.isClosed()) break;
                    listener.onError(webSocket, e);
                }
            }
        }, "web-socket-listener-" + this.id).start();
    }

    public int getId() {
        return this.id;
    }

    public static interface Listener {
        public void onReceived(@NotNull WebSocket var1, @NotNull Frame var2) throws IOException;

        public void onError(@NotNull WebSocket var1, @NotNull Throwable var2);

        default public void onClose(@NotNull WebSocket webSocket, @NotNull CloseFrame frame) throws IOException {
            webSocket.runSynchronisedWritable(() -> {
                webSocket.writeFrame(new WritableCloseFrame(frame.statusCode()));
                webSocket.close();
            });
        }
    }
}

