/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.other;

import de.linusdev.lutils.other.UnknownConstantException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberUtils {
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Number convertTo(@Nullable Number number, @NotNull Class<?> classToCastTo) {
        if (number == null) {
            return null;
        }
        if (classToCastTo.equals(Integer.class) || classToCastTo.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (classToCastTo.equals(Long.class) || classToCastTo.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (classToCastTo.equals(Byte.class) || classToCastTo.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (classToCastTo.equals(Short.class) || classToCastTo.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (classToCastTo.equals(Float.class) || classToCastTo.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (classToCastTo.equals(Double.class) || classToCastTo.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        throw new UnknownConstantException(classToCastTo);
    }
}

