/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.other.str;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface Part {
    public static Part constant(@NotNull String str) {
        return new Const(str);
    }

    public static Part placeholder(@NotNull String key) {
        return new Placeholder(key);
    }

    @NotNull
    public String get(@NotNull Map<String, String> var1);

    public static class Const
    implements Part {
        @NotNull
        private final String string;

        public Const(@NotNull String string) {
            this.string = string;
        }

        @Override
        @NotNull
        public String get(@NotNull Map<String, String> values) {
            return this.string;
        }
    }

    public static class Placeholder
    implements Part {
        @NotNull
        private final String key;

        public Placeholder(@NotNull String key) {
            this.key = key;
        }

        @Override
        @NotNull
        public String get(@NotNull Map<String, String> values) {
            return Objects.requireNonNull(values.get(this.key), () -> "'" + this.key + "' is missing!");
        }
    }
}

