/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.thread.pool;

import de.linusdev.lutils.interfaces.ExceptionHandler;
import de.linusdev.lutils.nat.memory.stack.Stack;
import de.linusdev.lutils.nat.memory.stack.StackFactory;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadWithStack
implements Runnable {
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final Stack stack;
    @NotNull
    private final ExceptionHandler exceptionHandler;
    @Nullable
    private volatile Runnable runnable;
    private long lastTaskEnded = System.currentTimeMillis();
    private boolean keepAlive = true;

    public ThreadWithStack(@NotNull ThreadFactory factory, @NotNull StackFactory stackFactory, @NotNull ExceptionHandler exceptionHandler) {
        this.stack = stackFactory.create();
        this.exceptionHandler = exceptionHandler;
        @NotNull Thread thread = factory.newThread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRunnableIfAvailable(@NotNull Function<Stack, Runnable> runnableGetter) {
        Object object = this.lock;
        synchronized (object) {
            if (this.runnable == null) {
                this.runnable = runnableGetter.apply(this.stack);
                this.lock.notify();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunningATask() {
        Object object = this.lock;
        synchronized (object) {
            return this.runnable != null;
        }
    }

    public void shutdown() {
        this.keepAlive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownIfLastRunPast(long duration) {
        Object object = this.lock;
        synchronized (object) {
            if (this.runnable == null && System.currentTimeMillis() - this.lastTaskEnded > duration) {
                this.shutdown();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiStatus.Internal
    public void run() {
        while (this.keepAlive) {
            @Nullable Runnable local = null;
            Object object = this.lock;
            synchronized (object) {
                try {
                    while (this.runnable == null && this.keepAlive) {
                        this.lock.wait();
                    }
                    local = this.runnable;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                if (local == null) continue;
                local.run();
                object = this.lock;
                synchronized (object) {
                    this.lastTaskEnded = System.currentTimeMillis();
                    this.runnable = null;
                }
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(throwable);
            }
        }
    }
}

