/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.thread.pool;

import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.Nothing;
import de.linusdev.lutils.async.completeable.CompletableFuture;
import de.linusdev.lutils.async.error.ThrowableAsyncError;
import de.linusdev.lutils.async.manager.AsyncManager;
import de.linusdev.lutils.interfaces.TFunction;
import de.linusdev.lutils.llist.LLinkedList;
import de.linusdev.lutils.nat.memory.stack.Stack;
import de.linusdev.lutils.nat.memory.stack.StackFactory;
import de.linusdev.lutils.thread.pool.ThreadWithStack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ThreadWithStackPool
implements AutoCloseable {
    private final int minThreadCount;
    private final long maxIdleMillis;
    @NotNull
    private final ThreadFactory threadFactory;
    @NotNull
    private final StackFactory stackFactory;
    @NotNull
    private final AsyncManager asyncManager;
    @NotNull
    private final LLinkedList<ThreadWithStack> threads;
    @NotNull
    private final ScheduledExecutorService sweeper;
    private boolean closed = false;

    public ThreadWithStackPool(int minThreadCount, long maxIdleMillis, @NotNull AsyncManager asyncManager, @NotNull ThreadFactory threadFactory, @NotNull StackFactory stackFactory) {
        this.minThreadCount = minThreadCount;
        this.maxIdleMillis = maxIdleMillis;
        this.asyncManager = asyncManager;
        this.threadFactory = threadFactory;
        this.stackFactory = stackFactory;
        this.threads = new LLinkedList();
        for (int i = 0; i < minThreadCount; ++i) {
            this.threads.add(new ThreadWithStack(threadFactory, stackFactory, Throwable::printStackTrace));
        }
        this.sweeper = Executors.newSingleThreadScheduledExecutor();
        this.sweeper.scheduleAtFixedRate(this::sweep, maxIdleMillis + 1000L, maxIdleMillis + 1000L, TimeUnit.MILLISECONDS);
    }

    private void sweep() {
        if (this.threads.size() <= this.minThreadCount) {
            return;
        }
        ThreadWithStack[] threads = new ThreadWithStack[this.threads.size()];
        int i = 0;
        int j = threads.length - 1;
        for (ThreadWithStack thread : this.threads) {
            if (thread.isRunningATask()) {
                threads[i++] = thread;
                continue;
            }
            threads[j--] = thread;
        }
        for (j = this.minThreadCount; j < threads.length; ++j) {
            if (!threads[j].shutdownIfLastRunPast(this.maxIdleMillis)) continue;
            this.threads.remove(threads[j]);
        }
    }

    @NotNull
    public <T> Future<T, Nothing> execute(@NotNull TFunction<Stack, T, ?> runnable) {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        CompletableFuture fut = CompletableFuture.create(this.asyncManager, false);
        Function<Stack, Runnable> fun = stack -> () -> {
            try {
                fut.complete(runnable.apply((Stack)stack), Nothing.INSTANCE, null);
            }
            catch (Throwable e) {
                fut.complete(null, Nothing.INSTANCE, new ThrowableAsyncError(e));
            }
        };
        for (ThreadWithStack thread : this.threads) {
            if (!thread.setRunnableIfAvailable(fun)) continue;
            return fut;
        }
        ThreadWithStack thread = new ThreadWithStack(this.threadFactory, this.stackFactory, Throwable::printStackTrace);
        if (!thread.setRunnableIfAvailable(fun)) {
            throw new Error();
        }
        this.threads.add(thread);
        return fut;
    }

    public int getCurrentThreadCount() {
        return this.threads.size();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.sweeper.shutdown();
        for (ThreadWithStack thread : this.threads) {
            thread.shutdown();
        }
    }
}

