/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev;

import com.mojang.logging.LogUtils;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.mixin.client.MinecraftClientAccessor;
import de.linusdev.oneworldfolder.ITitleScreenMixin;
import de.linusdev.oneworldfolder.config.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.TitleScreen;
import net.minecraft.util.Identifier;
import net.minecraft.world.level.storage.LevelStorage;
import org.jetbrains.annotations.Nullable;

public class OneWorldFolderModClient
implements ClientModInitializer {
    public static final Identifier OWF_TITLE_SCREEN_IDENTIFIER = Identifier.of((String)"oneworldfolder", (String)"titlescreen");
    public static final Identifier OWF_ICON_ID = Identifier.of((String)"oneworldfolder", (String)"icon/owf-icon-1024");
    public static final Identifier NO_SMALL_OWF_ICON_ID = Identifier.of((String)"oneworldfolder", (String)"icon/no-small-owf-icon-1024");
    public static LevelStorage customLevelStorage;
    public static boolean useCustomLevelStorage;
    public static Config config;

    public void onInitializeClient() {
        if (config == null) {
            return;
        }
        if (config.isSupportsCustomLevelStorage()) {
            customLevelStorage = new LevelStorage(config.getExternalMinecraftDirectory().resolve(config.getExternalSavesDirName()), config.getExternalMinecraftDirectory().resolve("backups"), LevelStorage.createSymlinkFinder((Path)config.getExternalMinecraftDirectory().resolve("allowed_symlinks.txt")), ((MinecraftClientAccessor)MinecraftClient.getInstance()).getDataFixer());
        }
        ScreenEvents.AFTER_INIT.register(OWF_TITLE_SCREEN_IDENTIFIER, (client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof TitleScreen) {
                ((ITitleScreenMixin)screen).oneworldfolder$addCustomButton();
            }
        });
        ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, OWF_TITLE_SCREEN_IDENTIFIER);
    }

    public static Config reloadConfig() {
        try {
            config = Config.from(OneWorldFolderModClient.getDefaultMinecraftFolder(), MinecraftClient.getInstance().runDirectory.toPath());
            return config;
        }
        catch (ParseException | IOException e) {
            LogUtils.getLogger().error("Cannot Load config: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static Path getDefaultMinecraftFolder() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.contains("win")) {
            return Paths.get(System.getenv("APPDATA"), ".minecraft");
        }
        if (OS.contains("nix") || OS.contains("nux")) {
            return Paths.get(System.getProperty("user.home"), ".minecraft");
        }
        return null;
    }

    static {
        useCustomLevelStorage = false;
        config = OneWorldFolderModClient.reloadConfig();
    }
}

