/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data;

import de.linusdev.data.Datable;
import de.linusdev.data.OptionalValue;
import de.linusdev.data.ParseType;
import de.linusdev.data.container.Container;
import de.linusdev.data.container.ContainerImpl;
import de.linusdev.data.entry.Entry;
import de.linusdev.data.functions.Converter;
import de.linusdev.data.functions.ExceptionConverter;
import de.linusdev.data.functions.ExceptionSupplier;
import de.linusdev.data.functions.ValueFactory;
import de.linusdev.data.parser.JsonParser;
import de.linusdev.lutils.other.NumberUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AbstractData<K, V>
extends Iterable<Entry<K, V>>,
Datable {
    public static final JsonParser PARSER = new JsonParser();

    public boolean add(@NotNull K var1, @Nullable V var2);

    default public boolean addIfNotNull(@NotNull K key, @Nullable V value) {
        if (value != null) {
            this.add(key, value);
            return true;
        }
        return false;
    }

    default public boolean addIfOptionalExists(@NotNull K key, @NotNull OptionalValue<? extends V> optionalValue) {
        if (optionalValue.exists()) {
            return this.add(key, optionalValue.get());
        }
        return false;
    }

    default public V addOrReplace(@NotNull K key, @Nullable V value) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            this.add(key, value);
            return null;
        }
        V old = entry.getValue();
        entry.setValue(value);
        return old;
    }

    public void addEntry(@NotNull Entry<K, V> var1);

    @Nullable
    public Entry<K, V> remove(@NotNull K var1);

    @Nullable
    public Entry<K, V> getEntry(@NotNull K var1);

    @NotNull
    default public <C> OptionalValue<C> getOptionalValue(@NotNull K key) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return OptionalValue.of();
        }
        return OptionalValue.of(entry.getValue());
    }

    @NotNull
    default public <C, R> OptionalValue<R> getOptionalValueAndConvert(@NotNull K key, @NotNull Converter<C, R> converter) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return OptionalValue.of();
        }
        return OptionalValue.of(converter.convert(entry.getValue()));
    }

    @NotNull
    default public <C, R, E extends Exception> OptionalValue<R> getOptionalValueAndConvertWithException(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter) throws E {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return OptionalValue.of();
        }
        return OptionalValue.of(converter.convert(entry.getValue()));
    }

    @NotNull
    default public Container<K, V, V> getContainer(@NotNull K key) {
        Entry<K, V> entry = this.getEntry(key);
        boolean exists = entry != null;
        return new ContainerImpl(this, key, (exists ? (Object)entry.getValue() : null), exists);
    }

    @Nullable
    default public V get(@NotNull K key, @Nullable V defaultObject, @Nullable V defaultObjectIfNull) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return defaultObject;
        }
        if (entry.getValue() == null) {
            return defaultObjectIfNull;
        }
        return entry.getValue();
    }

    @Contract(value="_, !null, !null -> !null")
    @Nullable
    default public V getOrDefault(@NotNull K key, @Nullable V defaultObject, @Nullable V defaultObjectIfNull) {
        return this.get(key, defaultObject, defaultObjectIfNull);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public V getOrDefaultBoth(@NotNull K key, @Nullable V defaultObject) {
        return this.get(key, defaultObject, defaultObject);
    }

    @Nullable
    default public V get(@NotNull K key, @Nullable V defaultObject) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return defaultObject;
        }
        return entry.getValue();
    }

    @Nullable
    default public V getOrDefault(@NotNull K key, @Nullable V defaultObject) {
        return this.get(key, defaultObject);
    }

    @Nullable
    default public V get(@NotNull K key) {
        return this.get(key, null);
    }

    @Contract(value="_, !null, !null -> !null")
    @Nullable
    default public <C extends V> C getAs(@NotNull K key, @Nullable C defaultObject, @Nullable C defaultObjectIfNull) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return defaultObject;
        }
        V value = entry.getValue();
        return (C)(value == null ? defaultObjectIfNull : value);
    }

    @Nullable
    default public <C extends V> C getAs(@NotNull K key, @Nullable C defaultObject) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return defaultObject;
        }
        return (C)entry.getValue();
    }

    @Nullable
    default public <C extends V> C getAs(@NotNull K key) {
        return this.getAs(key, null);
    }

    default public <C extends V, R> R getAndConvert(@NotNull K key, @NotNull Converter<C, R> converter) {
        V convertible = this.get(key);
        return converter.convert(convertible);
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <C extends V, R> R getAndConvert(@NotNull K key, @NotNull Converter<C, R> converter, @Nullable R defaultObject) {
        V convertible = this.get(key);
        if (convertible == null) {
            return defaultObject;
        }
        return converter.convert(convertible);
    }

    @Contract(value="_, _, !null, !null -> !null")
    @Nullable
    default public <C extends V, R> R getAndConvertOrDefault(@NotNull K key, @NotNull Converter<C, R> converter, @Nullable R defaultObject, @Nullable R defaultObjectIfNull) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return defaultObject;
        }
        return entry.getValue() == null ? defaultObjectIfNull : converter.convert(entry.getValue());
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <C extends V, R> R getAndConvertOrDefaultBoth(@NotNull K key, @NotNull Converter<C, R> converter, @Nullable R defaultObject) {
        return this.getAndConvert(key, converter, defaultObject);
    }

    @Nullable
    default public <C extends V, R, E extends Exception> R getAndConvertWithException(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter) throws E {
        V convertible = this.get(key);
        return converter.convert(convertible);
    }

    @Nullable
    default public <C extends V, R, E extends Exception> R getAndConvertWithException(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter, @Nullable R defaultObject) throws E {
        V convertible = this.get(key);
        if (convertible == null) {
            return defaultObject;
        }
        return converter.convert(convertible);
    }

    default public <E extends Exception> byte getNumberAsByte(@NotNull K key, @NotNull ValueFactory<K, Byte, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key);
        }
        return number.byteValue();
    }

    default public <E extends Exception> short getNumberAsShort(@NotNull K key, @NotNull ValueFactory<K, Short, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key);
        }
        return number.shortValue();
    }

    default public <E extends Exception> int getNumberAsInt(@NotNull K key, @NotNull ValueFactory<K, Integer, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key);
        }
        return number.intValue();
    }

    default public <E extends Exception> long getNumberAsLong(@NotNull K key, @NotNull ValueFactory<K, Long, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key);
        }
        return number.longValue();
    }

    default public <E extends Exception> float getNumberAsFloat(@NotNull K key, @NotNull ValueFactory<K, Float, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key).floatValue();
        }
        return number.floatValue();
    }

    default public <E extends Exception> double getNumberAsDouble(@NotNull K key, @NotNull ValueFactory<K, Double, E> valueFactory) throws E {
        Number number = (Number)this.get(key);
        if (number == null) {
            return valueFactory.create(key);
        }
        return number.doubleValue();
    }

    @Nullable
    default public List<Object> getList(@NotNull K key) {
        V value = this.get(key);
        return (List)value;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Object> getList(@NotNull K key, @Nullable List<Object> defaultList) {
        V value = this.get(key);
        return value == null ? defaultList : (List)value;
    }

    @Nullable
    default public <C, R> ArrayList<R> getListAndConvert(@NotNull K key, @NotNull Converter<C, R> converter) {
        List<Object> list = this.getList(key);
        if (list == null) {
            return null;
        }
        ArrayList<R> returnList = new ArrayList<R>(list.size());
        for (Object o : list) {
            returnList.add(converter.convert(o));
        }
        return returnList;
    }

    @Nullable
    default public <C, R, E extends Throwable> ArrayList<R> getListAndConvertWithException(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter) throws E {
        List<Object> list = this.getList(key);
        if (list == null) {
            return null;
        }
        ArrayList<R> returnList = new ArrayList<R>(list.size());
        for (Object o : list) {
            returnList.add(converter.convert(o));
        }
        return returnList;
    }

    @Nullable
    default public <C, R> ArrayList<R> getListAndConvertAndFreeMemory(@NotNull K key, @NotNull Converter<C, R> converter) {
        List<Object> list = this.getList(key);
        if (list == null) {
            return null;
        }
        ArrayList<R> returnList = new ArrayList<R>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            returnList.add(converter.convert(list.get(i)));
            list.set(i, null);
        }
        list.clear();
        return returnList;
    }

    @Nullable
    default public <C, R, E extends Throwable> ArrayList<R> getListAndConvertWithExceptionAndFreeMemory(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter) throws E {
        List<Object> list = this.getList(key);
        if (list == null) {
            return null;
        }
        ArrayList<R> returnList = new ArrayList<R>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            returnList.add(converter.convert(list.get(i)));
            list.set(i, null);
        }
        list.clear();
        return returnList;
    }

    default public <C extends V> boolean processIfContained(@NotNull K key, @NotNull Consumer<C> consumer) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            consumer.accept(entry.getValue());
            return true;
        }
        return false;
    }

    default public <C extends V, R> boolean convertAndProcessIfContained(@NotNull K key, @NotNull Converter<C, R> converter, @NotNull Consumer<R> consumer) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            consumer.accept(converter.convert(entry.getValue()));
            return true;
        }
        return false;
    }

    default public <C extends V, R, E extends Throwable> boolean convertWithExceptionAndProcessIfContained(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter, @NotNull Consumer<R> consumer) throws E {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            consumer.accept(converter.convert(entry.getValue()));
            return true;
        }
        return false;
    }

    default public boolean processListIfContained(@NotNull K key, @NotNull Consumer<List<Object>> consumer) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            consumer.accept((List)entry.getValue());
            return true;
        }
        return false;
    }

    default public <C, R> boolean convertAndProcessListIfContained(@NotNull K key, @NotNull Converter<C, R> converter, @NotNull Consumer<List<R>> consumer) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            List list = (List)entry.getValue();
            if (list == null) {
                consumer.accept(null);
                return true;
            }
            ArrayList<R> converted = new ArrayList<R>(list.size());
            for (Object o : list) {
                converted.add(converter.convert(o));
            }
            consumer.accept(converted);
            return true;
        }
        return false;
    }

    default public <C, R, E extends Throwable> boolean convertWithExceptionAndProcessListIfContained(@NotNull K key, @NotNull ExceptionConverter<C, R, E> converter, @NotNull Consumer<List<R>> consumer) throws E {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            List list = (List)entry.getValue();
            if (list == null) {
                consumer.accept(null);
                return true;
            }
            ArrayList<R> converted = new ArrayList<R>(list.size());
            for (Object o : list) {
                converted.add(converter.convert(o));
            }
            consumer.accept(converted);
            return true;
        }
        return false;
    }

    default public <C extends V, E extends Throwable> boolean processIfContainedAndRequireNotNull(@NotNull K key, @NotNull Consumer<C> consumer, ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        if (entry.getValue() == null) {
            throw exceptionSupplier.supply(this, key);
        }
        consumer.accept(entry.getValue());
        return true;
    }

    default public <C extends V, R, E extends Throwable> boolean convertAndProcessIfContainedAndRequireNotNull(@NotNull K key, Converter<C, R> converter, @NotNull Consumer<R> consumer, ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        if (entry.getValue() == null) {
            throw exceptionSupplier.supply(this, key);
        }
        consumer.accept(converter.convert(entry.getValue()));
        return true;
    }

    default public <C extends V, R, E extends Throwable, F extends Throwable> boolean convertWithExceptionAndProcessIfContainedAndRequireNotNull(@NotNull K key, ExceptionConverter<C, R, F> converter, @NotNull Consumer<R> consumer, ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E, F {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        if (entry.getValue() == null) {
            throw exceptionSupplier.supply(this, key);
        }
        consumer.accept(converter.convert(entry.getValue()));
        return true;
    }

    default public <C extends V> boolean processIfNotNull(@NotNull K key, @NotNull Consumer<C> consumer) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null && entry.getValue() != null) {
            consumer.accept(entry.getValue());
            return true;
        }
        return false;
    }

    @NotNull
    default public <E extends Throwable> Object getAndRequireNotNull(@NotNull K key, @NotNull ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E {
        V obj = this.get(key);
        if (obj == null) {
            throw exceptionSupplier.supply(this, key);
        }
        return obj;
    }

    @NotNull
    default public <C extends V, E extends Throwable> C getAsAndRequireNotNull(@NotNull K key, @NotNull ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E {
        V obj = this.get(key);
        if (obj == null) {
            throw exceptionSupplier.supply(this, key);
        }
        return (C)obj;
    }

    @NotNull
    default public <C extends V, R, E extends Throwable> R getAndRequireNotNullAndConvert(@NotNull K key, @NotNull Converter<C, R> converter, @NotNull ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E {
        V obj = this.get(key);
        if (obj == null) {
            throw exceptionSupplier.supply(this, key);
        }
        return converter.convert(obj);
    }

    @NotNull
    default public <C extends V, R, E extends Throwable, F extends Throwable> R getAndRequireNotNullAndConvertWithException(@NotNull K key, @NotNull ExceptionConverter<C, R, F> converter, @NotNull ExceptionSupplier<K, AbstractData<K, V>, E> exceptionSupplier) throws E, F {
        V obj = this.get(key);
        if (obj == null) {
            throw exceptionSupplier.supply(this, key);
        }
        return converter.convert(obj);
    }

    @NotNull
    default public <T extends Record> T toRecord(Class<T> recordClass) {
        if (!recordClass.isRecord()) {
            throw new IllegalArgumentException("Given recordClass '" + recordClass.getCanonicalName() + "' is not a record.");
        }
        RecordComponent[] comps = recordClass.getRecordComponents();
        Object[] params = new Object[comps.length];
        block3: for (Entry entry : this) {
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].getName().equals(entry.getKey().toString())) continue;
                if (comps[i].getType().isRecord() && entry.getValue() != null) {
                    params[i] = ((AbstractData)entry.getValue()).toRecord(comps[i].getType());
                    continue block3;
                }
                Object v = entry.getValue();
                if (v instanceof Number) {
                    Number num = (Number)v;
                    params[i] = NumberUtils.convertTo(num, comps[i].getType());
                    continue block3;
                }
                params[i] = entry.getValue();
                continue block3;
            }
        }
        Class[] componentTypes = (Class[])Arrays.stream(comps).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            return (T)((Record)recordClass.getDeclaredConstructor(componentTypes).newInstance(params));
        }
        catch (InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty();

    public int size();

    @NotNull
    default public StringBuilder toJsonString() {
        return PARSER.writeDataToStringBuilder(this);
    }

    @ApiStatus.Internal
    @NotNull
    default public ParseType getParseType() {
        return ParseType.NORMAL;
    }

    default public AbstractData<K, V> getData() {
        return this;
    }
}

