/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data;

import de.linusdev.data.OptionalValueImplementation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface OptionalValue<V> {
    public V get();

    default public <C> C getAs() {
        return (C)this.get();
    }

    default public boolean isNull() {
        return this.get() == null;
    }

    public boolean exists();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <V> OptionalValue<V> of(V value) {
        return new OptionalValueImplementation<V>(value, true);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> OptionalValue<V> of() {
        return new OptionalValueImplementation<Object>(null, false);
    }
}

