/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.container;

import de.linusdev.data.OptionalValue;
import de.linusdev.data.functions.Converter;
import de.linusdev.data.functions.ExceptionConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ListContainer<T>
extends OptionalValue<List<T>> {
    @ApiStatus.Internal
    @NotNull
    public <N> ListContainer<N> createNew(@Nullable List<N> var1);

    @NotNull
    default public <C> ListContainer<C> cast() {
        if (this.isNull()) {
            return this.createNew(null);
        }
        List list = (List)this.get();
        ArrayList converted = new ArrayList(list.size());
        for (Object t : list) {
            converted.add(t);
        }
        return this.createNew(converted);
    }

    @NotNull
    default public <C, R> ListContainer<R> castAndConvert(@NotNull Converter<C, R> converter) {
        return this.castAndConvertWithException(converter);
    }

    @NotNull
    default public <C, R, E extends Throwable> ListContainer<R> castAndConvertWithException(@NotNull ExceptionConverter<C, R, E> converter) throws E {
        if (this.isNull()) {
            return this.createNew(null);
        }
        List list = (List)this.get();
        ArrayList<R> converted = new ArrayList<R>(list.size());
        for (Object t : list) {
            converted.add(converter.convert(t));
        }
        return this.createNew(converted);
    }

    @NotNull
    default public ListContainer<T> process(@NotNull Consumer<List<T>> consumer) {
        consumer.accept((List)this.get());
        return this;
    }
}

