/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.implemantations;

import de.linusdev.data.entry.Entry;
import de.linusdev.data.so.SAOData;
import de.linusdev.data.so.SAOEntryImpl;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SAODataListImpl<O>
implements SAOData<O> {
    @NotNull
    protected List<Entry<String, O>> entries;

    public SAODataListImpl(@NotNull List<Entry<String, O>> list) {
        this.entries = list;
    }

    @Override
    public boolean add(@NotNull String key, O value) {
        return this.entries.add(new SAOEntryImpl<O>(key, value));
    }

    @Override
    public void addEntry(@NotNull Entry<String, O> entry) {
        this.entries.add(entry);
    }

    @Override
    public Entry<String, O> getEntry(@NotNull String key) {
        for (Entry<String, O> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Entry<String, O> remove(@NotNull String key) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).getKey().equals(key)) continue;
            return this.entries.remove(i);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<Entry<String, O>> iterator() {
        return this.entries.iterator();
    }
}

