/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.implemantations;

import de.linusdev.data.entry.Entry;
import de.linusdev.data.entry.MapEntryImpl;
import de.linusdev.data.so.SAOData;
import de.linusdev.data.so.SAOEntryImpl;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SAODataMapImpl<O>
implements SAOData<O> {
    protected final Map<String, O> entries;

    public SAODataMapImpl(Map<String, O> map) {
        this.entries = map;
    }

    @Override
    public boolean add(@NotNull String key, @Nullable O value) {
        this.entries.put(key, value);
        return true;
    }

    @Override
    public void addEntry(@NotNull Entry<String, O> entry) {
        this.entries.put(entry.getKey(), entry.getValue());
        entry.overwriteGetValue(stringObjectEntry -> this.entries.get(stringObjectEntry.getKey()));
        entry.overwriteSetValue((stringObjectEntry, o) -> {
            this.entries.put((String)stringObjectEntry.getKey(), o);
            stringObjectEntry.setValue(o);
        });
    }

    @Override
    @Nullable
    public Entry<String, O> remove(@NotNull String key) {
        return new SAOEntryImpl<O>(key, this.entries.remove(key));
    }

    @Override
    @Nullable
    public Entry<String, O> getEntry(@NotNull String key) {
        return new MapEntryImpl<O>(this.entries, key);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @NotNull
    public Iterator<Entry<String, O>> iterator() {
        return new Iterator<Entry<String, O>>(){
            final Iterator<String> keyIterator;
            {
                this.keyIterator = SAODataMapImpl.this.entries.keySet().stream().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            public Entry<String, O> next() {
                return new MapEntryImpl(SAODataMapImpl.this.entries, this.keyIterator.next());
            }
        };
    }
}

