/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async.error;

import de.linusdev.lutils.async.error.ErrorType;
import de.linusdev.lutils.async.exception.ErrorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AsyncError {
    @Nullable
    public Throwable getThrowable();

    @NotNull
    default public Throwable asThrowable() {
        if (this.hasThrowable()) {
            return this.getThrowable();
        }
        return new ErrorException(this);
    }

    default public boolean hasThrowable() {
        return this.getThrowable() != null;
    }

    @NotNull
    public ErrorType getType();

    @NotNull
    default public String getMessage() {
        if (!this.hasThrowable()) {
            return "";
        }
        return this.getThrowable().getMessage();
    }
}

