/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.bitfield;

import de.linusdev.lutils.bitfield.IntBitFieldValue;
import de.linusdev.lutils.bitfield.IntBitfieldImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface IntBitfield<V extends IntBitFieldValue> {
    @Contract(value="_ -> new")
    @NotNull
    public static <V extends IntBitFieldValue> IntBitfield<V> copy(@NotNull IntBitfield<V> toCopy) {
        return new IntBitfieldImpl(toCopy.getValue());
    }

    public int getValue();

    public void replaceWith(int var1);

    default public void replaceWith(@NotNull IntBitfield<V> flags) {
        this.replaceWith(flags.getValue());
    }

    @Contract(value="-> this")
    default public IntBitfield<V> reset() {
        this.replaceWith(0);
        return this;
    }

    default public boolean isSet(int flag) {
        return flag != 0 && (this.getValue() & flag) == flag;
    }

    default public boolean isSet(@NotNull V flag) {
        return this.isSet(flag.getValue());
    }

    default public boolean isSet(@NotNull IntBitfield<V> flags) {
        return this.isSet(flags.getValue());
    }

    default public void setFlag(int flag) {
        this.replaceWith(this.getValue() | flag);
    }

    default public void set(@NotNull V flag) {
        this.setFlag(flag.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
        this.setFlag(flag3.getValue());
    }

    default public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3, @NotNull V flag4) {
        this.setFlag(flag1.getValue());
        this.setFlag(flag2.getValue());
        this.setFlag(flag3.getValue());
        this.setFlag(flag4.getValue());
    }

    default public void set(@NotNull @NotNull V @NotNull [] flags) {
        for (V flag : flags) {
            this.setFlag(flag.getValue());
        }
    }

    default public void unset(@NotNull V flag) {
        this.unsetFlag(flag.getValue());
    }

    default public void unsetFlag(int flag) {
        this.replaceWith(this.getValue() & ~flag);
    }

    @NotNull
    default public @NotNull List<@NotNull V> toList(@NotNull Class<V> enumClass) {
        ArrayList<IntBitFieldValue> list = new ArrayList<IntBitFieldValue>(Integer.bitCount(this.getValue()));
        for (IntBitFieldValue c : (IntBitFieldValue[])enumClass.getEnumConstants()) {
            if (!this.isSet(c)) continue;
            list.add(c);
        }
        return list;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IntBitfield<V> and(int flags) {
        this.replaceWith(this.getValue() & flags);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IntBitfield<V> and(@NotNull IntBitfield<V> flags) {
        this.and(flags.getValue());
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IntBitfield<V> or(int flags) {
        this.replaceWith(this.getValue() | flags);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IntBitfield<V> or(@NotNull IntBitfield<V> flags) {
        this.or(flags.getValue());
        return this;
    }
}

