/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.java.JavaImport;
import de.linusdev.lutils.codegen.java.JavaPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaClass {
    @NotNull
    public static JavaClass custom(final @NotNull String jPackage, final @NotNull String name) {
        return new JavaClass(){

            @Override
            @NotNull
            public JavaPackage getPackage() {
                return new JavaPackage(jPackage);
            }

            @Override
            @NotNull
            public String getName() {
                return name;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof JavaClass)) {
                    return false;
                }
                return JavaClass.equals(this, (JavaClass)obj);
            }

            public int hashCode() {
                return JavaClass.hashcode(this);
            }
        };
    }

    @NotNull
    public static JavaClass ofClass(final @NotNull Class<?> clazz) {
        final JavaPackage p = clazz.isPrimitive() || clazz.isArray() && clazz.getComponentType().isPrimitive() ? null : JavaPackage.ofClass(clazz);
        return new JavaClass(){
            @Nullable
            private final JavaPackage jPackage;
            {
                this.jPackage = p;
            }

            @Override
            @NotNull
            public JavaPackage getPackage() {
                if (this.jPackage == null) {
                    throw new UnsupportedOperationException("Primitive types have no package.");
                }
                return this.jPackage;
            }

            @Override
            @NotNull
            public String getName() {
                return clazz.isArray() ? clazz.getComponentType().getSimpleName() : clazz.getSimpleName();
            }

            @Override
            public boolean isArray() {
                return clazz.isArray();
            }

            @Override
            public boolean isPrimitive() {
                return clazz.isArray() ? clazz.getComponentType().isPrimitive() : clazz.isPrimitive();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof JavaClass)) {
                    return false;
                }
                return JavaClass.equals(this, (JavaClass)obj);
            }

            public int hashCode() {
                return JavaClass.hashcode(this);
            }
        };
    }

    public static boolean equals(@NotNull JavaClass that, @NotNull JavaClass other) {
        if (!that.getPackage().equals(other.getPackage())) {
            return false;
        }
        if (!that.getName().equals(other.getName())) {
            return false;
        }
        if (!Arrays.equals(that.getGenerics(), other.getGenerics())) {
            return false;
        }
        return that.isPrimitive() == other.isPrimitive() && that.isArray() == other.isArray() && that.hasGenerics() == other.hasGenerics();
    }

    public static int hashcode(@NotNull JavaClass that) {
        int result = that.getPackage().hashCode();
        result = 31 * result + that.getName().hashCode();
        result = 31 * result + Boolean.hashCode(that.isPrimitive());
        result = 31 * result + Boolean.hashCode(that.isArray());
        result = 31 * result + Boolean.hashCode(that.hasGenerics());
        return result;
    }

    @NotNull
    public JavaPackage getPackage();

    @NotNull
    public String getName();

    @NotNull
    default public String getGenericsString() {
        if (this.hasGenerics()) {
            StringBuilder sb = new StringBuilder(this.getName());
            sb.append("<");
            boolean first = true;
            for (JavaClass generic : this.getGenerics()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(generic.getTypeName());
            }
            sb.append(">");
            return sb.toString();
        }
        return "";
    }

    @NotNull
    default public String getTypeName() {
        if (this.isArray()) {
            return this.getName() + "[]";
        }
        if (this.hasGenerics()) {
            StringBuilder sb = new StringBuilder(this.getName());
            sb.append("<");
            boolean first = true;
            for (JavaClass generic : this.getGenerics()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(generic.getTypeName());
            }
            sb.append(">");
            return sb.toString();
        }
        return this.getName();
    }

    @NotNull
    default public @NotNull JavaClass @NotNull [] getGenerics() {
        return new JavaClass[0];
    }

    default public boolean hasGenerics() {
        return false;
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean isArray() {
        return false;
    }

    @Nullable
    default public List<JavaImport> getRequiredImports() {
        if (this.isPrimitive()) {
            return null;
        }
        ArrayList<JavaImport> imports = new ArrayList<JavaImport>();
        imports.add(new JavaImport(this.getPackage(), this.getName(), null));
        for (JavaClass generic : this.getGenerics()) {
            if (generic.getRequiredImports() == null) continue;
            imports.addAll(generic.getRequiredImports());
        }
        return imports;
    }

    @NotNull
    default public JavaClass withGenerics(final JavaClass ... generics) {
        if (this.hasGenerics()) {
            throw new IllegalStateException("This class already has generics set.");
        }
        final JavaClass old = this;
        return new JavaClass(){

            @Override
            @NotNull
            public JavaPackage getPackage() {
                return old.getPackage();
            }

            @Override
            @NotNull
            public String getName() {
                return old.getName();
            }

            @Override
            public boolean hasGenerics() {
                return true;
            }

            @Override
            @NotNull
            public @NotNull JavaClass @NotNull [] getGenerics() {
                return generics;
            }
        };
    }

    @Nullable
    default public Class<?> tryResolveActualClass() {
        try {
            return Class.forName(this.getPackage().getPackageString() + "." + this.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

