/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaAnnotateable;
import de.linusdev.lutils.codegen.java.JavaAnnotation;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaDocGenerator;
import de.linusdev.lutils.codegen.java.JavaDocable;
import de.linusdev.lutils.codegen.java.JavaExpression;
import de.linusdev.lutils.codegen.java.JavaFileState;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEnumMemberGenerator
implements PartGenerator<JavaSourceGeneratorHelper>,
JavaAnnotateable,
JavaDocable {
    @NotNull
    protected final JavaFileState ft;
    @NotNull
    protected final String name;
    @NotNull
    protected final @NotNull JavaExpression @NotNull [] parameters;
    @Nullable
    protected JavaDocGenerator javaDoc = null;
    @NotNull
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();

    public JavaEnumMemberGenerator(@NotNull JavaFileState ft, @NotNull String name, JavaExpression ... parameters) {
        this.ft = ft;
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> state) throws IOException {
        if (this.javaDoc != null) {
            this.javaDoc.write(writer, state);
        }
        for (JavaAnnotation annotation : this.annotations) {
            writer.append(state.getIndent()).append(state.getSg().javaAnnotation(annotation)).append(state.getSg().javaLineBreak());
        }
        writer.append(state.getIndent()).append(this.name);
        if (this.parameters.length > 0) {
            writer.append("(");
            boolean first = true;
            for (JavaExpression parameter : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                writer.append(parameter.getExprString(state.getSg()));
            }
            writer.append(")");
        }
    }

    @Override
    @NotNull
    public JavaAnnotation addAnnotation(@NotNull JavaClass annotationClass) {
        JavaAnnotation annotation = new JavaAnnotation(this.ft, annotationClass);
        this.annotations.add(annotation);
        return annotation;
    }

    @Override
    @NotNull
    public JavaDocGenerator setJavaDoc() {
        if (this.javaDoc == null) {
            this.javaDoc = new JavaDocGenerator();
        }
        return this.javaDoc;
    }
}

