/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color.impl;

import de.linusdev.lutils.color.RGBAColor;

public class RGBAColorIntImpl
implements RGBAColor {
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public RGBAColorIntImpl(int red, int green, int blue, int alpha) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255 || alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("No color int value may be above 255 or below 0. r, g, b, a: " + red + ", " + green + ", " + blue + ", " + alpha + ".");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public double red() {
        return (double)this.red / 255.0;
    }

    @Override
    public double green() {
        return (double)this.green / 255.0;
    }

    @Override
    public double blue() {
        return (double)this.blue / 255.0;
    }

    @Override
    public double alpha() {
        return (double)this.alpha / 255.0;
    }

    public String toString() {
        return "(" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + ")";
    }
}

