/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html;

import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlAttributeMap
implements Iterable<HtmlAttribute> {
    @NotNull
    private final Map<String, HtmlAttribute> attributes = new HashMap<String, HtmlAttribute>();

    @Nullable
    public HtmlAttribute put(@NotNull HtmlAttribute attribute) {
        return this.attributes.put(attribute.type().name(), attribute);
    }

    @Nullable
    public HtmlAttribute remove(@NotNull HtmlAttributeType<?> type) {
        return this.attributes.remove(type.name());
    }

    @Nullable
    public HtmlAttribute get(@NotNull HtmlAttributeType<?> type) {
        return this.attributes.get(type.name());
    }

    public <V> V getValue(@NotNull HtmlAttributeType<V> type) {
        HtmlAttribute attribute = this.attributes.get(type.name());
        if (attribute == null) {
            return null;
        }
        return type.convertValue(attribute);
    }

    @Override
    @NotNull
    public Iterator<HtmlAttribute> iterator() {
        return this.attributes.values().iterator();
    }

    public int size() {
        return this.attributes.size();
    }
}

