/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.impl;

import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectParser;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.HtmlUtils;
import de.linusdev.lutils.html.parser.HtmlWritingState;
import de.linusdev.lutils.result.BiResult;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class HtmlText
implements HtmlObject {
    @NotNull
    public static final HtmlObjectParser<HtmlText> PARSER = (state, reader) -> {
        StringBuilder text = new StringBuilder();
        BiResult<String, Character> res = reader.readEscapedUntil('<', '\n');
        text.append(res.result1());
        while (res.result2().charValue() != '<') {
            if (!reader.availableSkipNewLinesAndSpaces()) {
                throw new EOFException();
            }
            res = reader.readEscapedUntil('<', '\n');
            if (res.result1().isEmpty()) continue;
            text.append(' ');
            text.append(res.result1());
        }
        reader.pushBack('<');
        return new HtmlText(text.toString());
    };
    @NotNull
    private final String text;

    public HtmlText(@NotNull String text) {
        this.text = text;
    }

    @Override
    @NotNull
    public HtmlObjectType type() {
        return HtmlObjectType.TEXT;
    }

    @Override
    @NotNull
    public HtmlObject copy() {
        return this;
    }

    @Override
    public void write(@NotNull HtmlWritingState state, @NotNull Writer writer) throws IOException {
        String processed = HtmlUtils.escape(this.text, false);
        processed = processed.replaceAll("\n", "\n" + state.getIndent());
        writer.write(processed);
    }
}

