/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.impl;

import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeType;
import org.jetbrains.annotations.NotNull;

public class StandardHtmlAttributeTypes {
    @NotNull
    public static final HtmlAttributeType<String[]> CLASS = new ListType("class");
    @NotNull
    public static final HtmlAttributeType<String> ID = new StringType("id");
    @NotNull
    public static final HtmlAttributeType<String> HREF = new StringType("href");
    @NotNull
    public static final HtmlAttributeType<String> REL = new StringType("rel");
    @NotNull
    public static final @NotNull HtmlAttributeType<?> @NotNull [] VALUES = new HtmlAttributeType[]{CLASS, ID, HREF, REL};

    public static class ListType
    extends Type<String[]> {
        public ListType(@NotNull String name) {
            super(name);
        }

        @Override
        public String @NotNull [] convertValue(@NotNull HtmlAttribute attribute) {
            String val = attribute.value();
            return val == null ? new String[]{} : val.split(" ");
        }
    }

    public static class StringType
    extends Type<String> {
        public StringType(@NotNull String name) {
            super(name);
        }

        @Override
        @NotNull
        public String convertValue(@NotNull HtmlAttribute attribute) {
            String val = attribute.value();
            return val == null ? "" : val;
        }
    }

    public static abstract class Type<V>
    implements HtmlAttributeType<V> {
        @NotNull
        private final String name;

        public Type(@NotNull String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        public int hashCode() {
            return HtmlAttributeType.hashcode(this);
        }
    }
}

