/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml.skeleton;

import de.linusdev.lutils.html.EditableHtmlElement;
import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.impl.HtmlPage;
import de.linusdev.lutils.html.lhtml.LhtmlHead;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholder;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderElement;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlPageSkeleton;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlTemplateSkeleton;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LhtmlSkeletonBuilder {
    @NotNull
    private final HashMap<String, LhtmlPlaceholder> placeholders = new HashMap();
    @NotNull
    private final HashMap<String, LhtmlTemplateSkeleton> templates = new HashMap();
    @Nullable
    private LhtmlHead head = null;
    @Nullable
    private HtmlElement body = null;

    public void addPlaceholder(@NotNull LhtmlPlaceholderElement element) {
        LhtmlPlaceholder holder = this.placeholders.computeIfAbsent(element.getId(), LhtmlPlaceholder::new);
        holder.addPlaceholderElement(element);
    }

    public void addTemplate(@NotNull LhtmlTemplateSkeleton template) {
        if (this.templates.put(template.getId(), template) != null) {
            throw new IllegalStateException("A template with the id '" + template.getId() + " already exists.");
        }
    }

    public void setHead(@NotNull LhtmlHead head) {
        this.head = head;
    }

    public void setBody(@NotNull HtmlElement body) {
        this.body = body;
    }

    @NotNull
    public LhtmlTemplateSkeleton buildTemplate(@NotNull String id, @NotNull EditableHtmlElement element) {
        return new LhtmlTemplateSkeleton(id, element, this.templates);
    }

    @NotNull
    public LhtmlPageSkeleton buildPage(@NotNull HtmlPage actual) {
        if (this.head == null) {
            throw new IllegalArgumentException("LhtmlPage is missing a head element.");
        }
        if (this.body == null) {
            throw new IllegalArgumentException("LhtmlPage is missing a body element.");
        }
        return new LhtmlPageSkeleton(actual, this.templates);
    }
}

