/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml.skeleton;

import de.linusdev.lutils.html.EditableHtmlElement;
import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholder;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderAttribute;
import de.linusdev.lutils.html.lhtml.LhtmlPlaceholderElement;
import de.linusdev.lutils.html.lhtml.LhtmlTemplateElement;
import de.linusdev.lutils.html.lhtml.skeleton.LhtmlSkeleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LhtmlTemplateSkeleton
implements LhtmlSkeleton {
    @NotNull
    protected final String id;
    @NotNull
    protected final Map<String, LhtmlTemplateSkeleton> templates;
    @NotNull
    protected final EditableHtmlElement actual;

    @ApiStatus.Internal
    @NotNull
    public static LhtmlTemplateElement createCopy(@NotNull String id, @NotNull EditableHtmlElement actual, Map<String, LhtmlTemplateSkeleton> templates) {
        EditableHtmlElement copy = actual.copy();
        HashMap<String, LhtmlPlaceholder> placeholders = new HashMap<String, LhtmlPlaceholder>();
        HashMap<String, String> replaceValues = new HashMap<String, String>();
        Consumer<HtmlAttribute> attrConsumer = attribute -> {
            if (attribute instanceof LhtmlPlaceholderAttribute) {
                LhtmlPlaceholderAttribute placeholderAttr = (LhtmlPlaceholderAttribute)attribute;
                placeholderAttr.setReplaceValues(replaceValues);
            }
        };
        Consumer<HtmlObject> consumer = object -> {
            if (object.type() == HtmlObjectType.ELEMENT) {
                object.asHtmlElement().iterateAttributes(attrConsumer);
                if (object instanceof LhtmlPlaceholderElement) {
                    LhtmlPlaceholderElement placeholderEle = (LhtmlPlaceholderElement)object;
                    LhtmlPlaceholder holder = placeholders.computeIfAbsent(placeholderEle.getId(), LhtmlPlaceholder::new);
                    holder.addPlaceholderElement(placeholderEle);
                }
            }
        };
        copy.iterateContentRecursive(consumer);
        copy.iterateAttributes(attrConsumer);
        return new LhtmlTemplateElement(id, copy, placeholders, templates, replaceValues);
    }

    public LhtmlTemplateSkeleton(@NotNull String id, @NotNull EditableHtmlElement actual, @NotNull Map<String, LhtmlTemplateSkeleton> templates) {
        this.id = id;
        this.templates = templates;
        this.actual = actual;
    }

    @Override
    @NotNull
    public LhtmlTemplateElement copy() {
        return LhtmlTemplateSkeleton.createCopy(this.id, this.actual, this.templates);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public LhtmlTemplateElement getTemplate(@NotNull String id) {
        return Objects.requireNonNull(this.templates.get(id)).copy();
    }
}

