/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.parser;

import de.linusdev.lutils.html.parser.AttrReaderState;
import de.linusdev.lutils.html.parser.HtmlParserState;
import de.linusdev.lutils.html.parser.HtmlReader;
import de.linusdev.lutils.html.parser.ParseException;
import de.linusdev.lutils.result.BiResult;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AttributeReader {
    @NotNull
    private final HtmlReader reader;
    @NotNull
    private final HtmlParserState parserState;
    public AttrReaderState state = AttrReaderState.READING;

    public AttributeReader(@NotNull HtmlReader reader, @NotNull HtmlParserState parserState) {
        this.reader = reader;
        this.parserState = parserState;
    }

    public String readAttributeName() throws IOException, ParseException {
        char r = this.reader.skipNewLinesAndSpaces();
        if (r == '>') {
            this.state = AttrReaderState.TAG_END;
            return null;
        }
        if (r == '/') {
            r = this.reader.read();
            if (r != '>') {
                throw this.parserState.fail(r);
            }
            this.state = AttrReaderState.TAG_SELF_CLOSE;
            return null;
        }
        this.reader.pushBack(r);
        BiResult<String, Character> res = this.reader.readUntil('=', ' ', '>', '/');
        if (res.result2().charValue() == '>') {
            this.state = AttrReaderState.TAG_END;
            return res.result1();
        }
        if (res.result2().charValue() == '/') {
            r = this.reader.read();
            if (r != '>') {
                throw this.parserState.fail(r);
            }
            this.state = AttrReaderState.TAG_SELF_CLOSE;
            return res.result1();
        }
        if (res.result2().charValue() == ' ') {
            this.state = AttrReaderState.READING;
            return res.result1();
        }
        this.state = AttrReaderState.ATTR_VALUE;
        return res.result1();
    }

    @NotNull
    public String readAttributeValue() throws IOException {
        if (this.state != AttrReaderState.ATTR_VALUE) {
            throw new IllegalStateException("State is not ATTR_VALUE, but is " + this.state);
        }
        this.state = AttrReaderState.READING;
        return this.reader.readString();
    }
}

