/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.parser;

import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.impl.HtmlPage;
import de.linusdev.lutils.html.parser.HtmlParserState;
import de.linusdev.lutils.html.parser.HtmlReader;
import de.linusdev.lutils.html.parser.ParseException;
import de.linusdev.lutils.html.parser.Registry;
import de.linusdev.lutils.result.BiResult;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlParser {
    @NotNull
    private final Registry registry;

    public HtmlParser(@NotNull Registry registry) {
        this.registry = registry;
    }

    @NotNull
    public HtmlPage parsePage(@NotNull Reader reader) throws IOException, ParseException {
        return HtmlPage.PARSER.parse(new HtmlParserState(null, this), new HtmlReader(reader));
    }

    @Nullable
    public HtmlObject parseIfPresent(@NotNull HtmlParserState state, @NotNull HtmlReader reader) throws IOException, ParseException {
        if (!reader.availableSkipNewLinesAndSpaces()) {
            return null;
        }
        return this.parse(state, reader);
    }

    @NotNull
    public HtmlObject parse(@NotNull HtmlParserState state, @NotNull HtmlReader reader) throws IOException, ParseException {
        char[] buf = new char[3];
        buf[0] = reader.skipNewLinesAndFollowingSpaces();
        if (buf[0] == '<') {
            buf[1] = reader.read();
            if (buf[1] == '!') {
                buf[2] = reader.read();
                if (buf[2] == '-') {
                    reader.pushBack(buf, 3);
                    return this.registry.getCommentParser().parse(state, reader);
                }
                reader.pushBack(buf, 3);
                return this.registry.getDocTypeParser().parse(state, reader);
            }
            reader.pushBack(buf[1]);
            return this.parseElement(state, reader);
        }
        reader.pushBack(buf[0]);
        return this.registry.getTextParser().parse(state, reader);
    }

    @NotNull
    private HtmlElement parseElement(@NotNull HtmlParserState state, @NotNull HtmlReader reader) throws IOException, ParseException {
        BiResult<String, Character> res = reader.readUntil(' ', '>');
        HtmlElementType<?> type = this.registry.getElementTypeByName(res.result1());
        reader.pushBack(res.result2().charValue());
        reader.pushBack(res.result1());
        reader.pushBack('<');
        return type.parser().parse(state, reader);
    }

    @NotNull
    public Registry getRegistry() {
        return this.registry;
    }
}

