/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.parser;

import de.linusdev.lutils.html.HtmlAttributeType;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObjectParser;
import de.linusdev.lutils.html.impl.HtmlComment;
import de.linusdev.lutils.html.impl.HtmlDocType;
import de.linusdev.lutils.html.impl.HtmlText;
import de.linusdev.lutils.html.impl.StandardHtmlAttributeTypes;
import de.linusdev.lutils.html.impl.element.StandardHtmlElement;
import de.linusdev.lutils.html.impl.element.StandardHtmlElementTypes;
import java.util.HashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Registry {
    @NotNull
    private final HashMap<String, HtmlElementType<?>> elements;
    @NotNull
    private final HashMap<String, HtmlAttributeType<?>> attributes;
    @NotNull
    private final HtmlObjectParser<?> docTypeParser;
    @NotNull
    private final HtmlObjectParser<?> textParser;
    @NotNull
    private final HtmlObjectParser<?> commentParser;
    @NotNull
    private final Function<String, HtmlElementType<?>> defaultElementType;
    @NotNull
    private final Function<String, HtmlAttributeType<?>> defaultAttributeType;

    @NotNull
    public static Builder getDefault() {
        Builder builder = new Builder();
        for (HtmlElementType<?> eleType : StandardHtmlElementTypes.VALUES) {
            builder.putElement(eleType);
        }
        for (HtmlAttributeType<?> attrType : StandardHtmlAttributeTypes.VALUES) {
            builder.addAttribute(attrType);
        }
        return builder;
    }

    Registry(@NotNull HashMap<String, HtmlElementType<?>> elements, @NotNull HashMap<String, HtmlAttributeType<?>> attributes, @NotNull HtmlObjectParser<?> docTypeParser, @NotNull HtmlObjectParser<?> textParser, @NotNull HtmlObjectParser<?> commentParser, @NotNull Function<String, HtmlElementType<?>> defaultElementType, @NotNull Function<String, HtmlAttributeType<?>> defaultAttributeType) {
        this.elements = elements;
        this.attributes = attributes;
        this.docTypeParser = docTypeParser;
        this.textParser = textParser;
        this.commentParser = commentParser;
        this.defaultElementType = defaultElementType;
        this.defaultAttributeType = defaultAttributeType;
    }

    @NotNull
    public HtmlElementType<?> getElementTypeByName(@NotNull String name) {
        HtmlElementType<?> type = this.elements.get(name);
        if (type != null) {
            return type;
        }
        return this.defaultElementType.apply(name);
    }

    @NotNull
    public HtmlAttributeType<?> getAttributeTypeByName(@NotNull String name) {
        HtmlAttributeType<?> type = this.attributes.get(name);
        if (type != null) {
            return type;
        }
        return this.defaultAttributeType.apply(name);
    }

    @NotNull
    public HtmlObjectParser<?> getDocTypeParser() {
        return this.docTypeParser;
    }

    @NotNull
    public HtmlObjectParser<?> getTextParser() {
        return this.textParser;
    }

    @NotNull
    public HtmlObjectParser<?> getCommentParser() {
        return this.commentParser;
    }

    public static class Builder {
        @NotNull
        private final HashMap<String, HtmlElementType<?>> elements = new HashMap();
        @NotNull
        private final HashMap<String, HtmlAttributeType<?>> attributes = new HashMap();
        @NotNull
        private HtmlObjectParser<?> docTypeParser = HtmlDocType.PARSER;
        @NotNull
        private HtmlObjectParser<?> textParser = HtmlText.PARSER;
        @NotNull
        private HtmlObjectParser<?> commentParser = HtmlComment.PARSER;
        @NotNull
        private Function<String, HtmlElementType<?>> defaultElementType = StandardHtmlElement.Type::newInline;
        @NotNull
        private Function<String, HtmlAttributeType<?>> defaultAttributeType = StandardHtmlAttributeTypes.StringType::new;

        public void putElement(@NotNull HtmlElementType<?> type) {
            this.elements.put(type.name(), type);
        }

        public void addAttribute(@NotNull HtmlAttributeType<?> type) {
            if (this.attributes.put(type.name(), type) != null) {
                throw new IllegalStateException("Attribute with name '" + type.name() + "' already exists.");
            }
        }

        public void setDocTypeParser(@NotNull HtmlObjectParser<?> docTypeParser) {
            this.docTypeParser = docTypeParser;
        }

        public void setTextParser(@NotNull HtmlObjectParser<?> textParser) {
            this.textParser = textParser;
        }

        public void setCommentParser(@NotNull HtmlObjectParser<?> commentParser) {
            this.commentParser = commentParser;
        }

        public void setDefaultElementType(@NotNull Function<String, HtmlElementType<?>> defaultElementType) {
            this.defaultElementType = defaultElementType;
        }

        public void setDefaultAttributeType(@NotNull Function<String, HtmlAttributeType<?>> defaultAttributeType) {
            this.defaultAttributeType = defaultAttributeType;
        }

        public Registry build() {
            return new Registry(this.elements, this.attributes, this.docTypeParser, this.textParser, this.commentParser, this.defaultElementType, this.defaultAttributeType);
        }
    }
}

