/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image;

import de.linusdev.lutils.ansi.sgr.SGR;
import de.linusdev.lutils.color.Color;
import de.linusdev.lutils.color.RGBAColor;
import de.linusdev.lutils.image.ImageSize;
import de.linusdev.lutils.image.java.JavaBackedImage;
import de.linusdev.lutils.image.view.ImageView;
import de.linusdev.lutils.image.view.RotatedImageView;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public interface Image
extends ImageSize {
    public static void copy(@NotNull Image src, @NotNull Image dst) {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Destination image is read only.");
        }
        if (dst.getWidth() < src.getWidth()) {
            throw new IllegalArgumentException("Destination image's width is too small");
        }
        if (dst.getHeight() < src.getHeight()) {
            throw new IllegalArgumentException("Destination image's height is too small");
        }
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                dst.setPixelAsRGBA(x, y, src.getPixelAsRGBA(x, y));
            }
        }
    }

    public static void copy(@NotNull Image src, int srcOffsetX, int srcOffsetY, @NotNull Image dst, int dstOffsetX, int dstOffsetY) {
        int width = src.getWidth() - srcOffsetX;
        int height = src.getHeight() - srcOffsetY;
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Destination image is read only.");
        }
        if (dst.getWidth() - dstOffsetX < width) {
            throw new IllegalArgumentException("Destination image's width is too small");
        }
        if (dst.getHeight() - dstOffsetY < height) {
            throw new IllegalArgumentException("Destination image's height is too small");
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dst.setPixelAsRGBA(dstOffsetX + x, dstOffsetY + y, src.getPixelAsRGBA(srcOffsetX + x, srcOffsetY + y));
            }
        }
    }

    public static boolean equals(@NotNull Image that, @NotNull Image other) {
        if (that.getWidth() != other.getWidth()) {
            return false;
        }
        if (that.getHeight() != other.getHeight()) {
            return false;
        }
        for (int y = 0; y < that.getHeight(); ++y) {
            for (int x = 0; x < that.getWidth(); ++x) {
                if (that.getPixelAsRGBA(x, y) == other.getPixelAsRGBA(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static String printable(@NotNull Image image) {
        StringBuilder ret = new StringBuilder();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                RGBAColor color = image.getPixelAsRGBAColor(x, y);
                ret.append(color.addToSgrAsBackground(new SGR()).construct()).append("  ").append(SGR.reset());
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    @NotNull
    public static Image fill(@NotNull Image image, @NotNull Color color) {
        int rgba = color.toRGBAColor().toRGBAHex();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                image.setPixelAsRGBA(x, y, rgba);
            }
        }
        return image;
    }

    @NotNull
    public static Image create(int width, int height) {
        return new JavaBackedImage(new BufferedImage(width, height, 2));
    }

    public int getPixelAsRGBA(int var1, int var2);

    public void setPixelAsRGBA(int var1, int var2, int var3);

    @NotNull
    default public RGBAColor getPixelAsRGBAColor(int x, int y) {
        return Color.ofRGBA(this.getPixelAsRGBA(x, y));
    }

    public boolean isReadOnly();

    @NotNull
    default public Image createView(int offsetX, int offsetY) {
        return new ImageView(this, offsetX, offsetY, this.getWidth() - offsetX, this.getHeight() - offsetY);
    }

    @NotNull
    default public Image createView(int offsetX, int offsetY, int width, int height) {
        return new ImageView(this, offsetX, offsetY, width, height);
    }

    @NotNull
    default public Image createRotatedView() {
        return new RotatedImageView(this);
    }
}

