/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.atlas;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.atlas.Atlas;
import org.jetbrains.annotations.NotNull;

public class AtlasImage<ID>
implements Image {
    @NotNull
    private final Atlas<?, ID> atlas;
    private final ID id;
    private final boolean rotated;
    private final double uvXStart;
    private final double uvYStart;
    private final double uvXEnd;
    private final double uvYEnd;
    private final int xStart;
    private final int yStart;
    private final int width;
    private final int height;

    public AtlasImage(@NotNull Atlas<?, ID> atlas, ID id, boolean rotated, double uvXStart, double uvYStart, double uvXEnd, double uvYEnd, int xStart, int yStart, int width, int height) {
        this.atlas = atlas;
        this.id = id;
        this.rotated = rotated;
        this.uvXStart = uvXStart;
        this.uvYStart = uvYStart;
        this.uvXEnd = uvXEnd;
        this.uvYEnd = uvYEnd;
        this.xStart = xStart;
        this.yStart = yStart;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getPixelAsRGBA(int x, int y) {
        return this.atlas.getPixelAsRGBA(this.xStart + x, this.yStart + y);
    }

    @Override
    public void setPixelAsRGBA(int x, int y, int rgba) {
        this.atlas.setPixelAsRGBA(this.xStart + x, this.yStart + y, rgba);
    }

    @Override
    public boolean isReadOnly() {
        return this.atlas.isReadOnly();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public double getUvXStart() {
        return this.uvXStart;
    }

    public double getUvXEnd() {
        return this.uvXEnd;
    }

    public double getUvYStart() {
        return this.uvYStart;
    }

    public double getUvYEnd() {
        return this.uvYEnd;
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public ID getId() {
        return this.id;
    }
}

