/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.view;

import de.linusdev.lutils.image.Image;
import org.jetbrains.annotations.NotNull;

public class ImageView
implements Image {
    @NotNull
    private final Image original;
    private final int offsetX;
    private final int offsetY;
    private final int width;
    private final int height;

    public ImageView(@NotNull Image original, int offsetX, int offsetY, int width, int height) {
        this.original = original;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.width = width;
        this.height = height;
        this.checks();
    }

    private void checks() {
        if (this.original.getWidth() - this.offsetX < this.width) {
            throw new IllegalArgumentException("Original image width (" + this.original.getWidth() + ") is too small for image view with offsetX=" + this.offsetX + " and width=" + this.width + ".");
        }
        if (this.original.getHeight() - this.offsetY < this.height) {
            throw new IllegalArgumentException("Original image height (" + this.original.getHeight() + ") is too small for image view with offsetY=" + this.offsetY + " and height=" + this.height + ".");
        }
    }

    @Override
    public int getPixelAsRGBA(int x, int y) {
        return this.original.getPixelAsRGBA(this.offsetX + x, this.offsetY + y);
    }

    @Override
    public void setPixelAsRGBA(int x, int y, int rgba) {
        this.original.setPixelAsRGBA(this.offsetX + x, this.offsetY + y, rgba);
    }

    @Override
    public boolean isReadOnly() {
        return this.original.isReadOnly();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

