/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.wip_webp.reader;

import de.linusdev.lutils.image.wip_webp.reader.WebPReaderException;
import de.linusdev.lutils.image.wip_webp.reader.WebReaderUtils;
import org.jetbrains.annotations.NotNull;

public enum WebPImageType {
    SIMPLE_LOSSY(32),
    SIMPLE_LOSSLESS(76),
    EXTENDED(88);

    private final byte lastFourCCByte;

    @NotNull
    public static WebPImageType of(byte[] data, int offset) throws WebPReaderException {
        if (!WebReaderUtils.checkChunkThreeCC(data, offset, WebReaderUtils.VP8)) {
            throw new WebPReaderException("Unknown webp type: " + WebReaderUtils.convertChunkFourCC(data, offset));
        }
        byte lastFourCC = WebReaderUtils.getChunkFourCC(data, offset);
        if (lastFourCC == WebPImageType.SIMPLE_LOSSY.lastFourCCByte) {
            return SIMPLE_LOSSY;
        }
        if (lastFourCC == WebPImageType.SIMPLE_LOSSLESS.lastFourCCByte) {
            return SIMPLE_LOSSLESS;
        }
        if (lastFourCC == WebPImageType.EXTENDED.lastFourCCByte) {
            return EXTENDED;
        }
        throw new WebPReaderException("Unknown webp type: " + WebReaderUtils.convertChunkFourCC(data, offset));
    }

    private WebPImageType(byte lastFourCCByte) {
        this.lastFourCCByte = lastFourCCByte;
    }

    public byte getLastFourCCByte() {
        return this.lastFourCCByte;
    }
}

