/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math;

import org.jetbrains.annotations.Range;

public class LMath {
    public static final float PIf = (float)Math.PI;

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static long clamp(long value, long min, long max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int minUnsigned(int first, int second) {
        return Integer.compareUnsigned(first, second) == 1 ? second : first;
    }

    public static int maxUnsigned(int first, int second) {
        return Integer.compareUnsigned(first, second) == -1 ? second : first;
    }

    public static int clampUnsigned(int value, int min, int max) {
        return LMath.minUnsigned(LMath.maxUnsigned(value, min), max);
    }

    public static int intLog2(int value) {
        if (value == 0) {
            return 0;
        }
        return Integer.numberOfTrailingZeros(Integer.highestOneBit(value));
    }

    public static double interpolate(double minPos, double maxPos, double minOut, double maxOut, double pos) {
        pos = LMath.clamp(pos, minPos, maxPos) - minPos;
        double normalizedPos = pos / (maxPos - minPos);
        return LMath.interpolate(minOut, maxOut, normalizedPos);
    }

    public static double interpolate(double minOut, double maxOut, @Range(from=0L, to=1L) double pos) {
        return minOut * (1.0 - pos) + maxOut * pos;
    }
}

