/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix;

import de.linusdev.lutils.math.matrix.MatrixMemoryLayout;
import de.linusdev.lutils.math.matrix.abstracts.floatn.FloatMxN;
import de.linusdev.lutils.math.vector.Vector;
import org.jetbrains.annotations.NotNull;

public interface Matrix
extends Vector {
    public static boolean equals(@NotNull FloatMxN matrix, float @NotNull [] data, float epsilon) {
        if (matrix.getWidth() * matrix.getHeight() != data.length) {
            return false;
        }
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                if (!(Math.abs(matrix.get(y, x) - data[y * matrix.getWidth() + x]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(@NotNull FloatMxN matrix, @NotNull FloatMxN other, float epsilon) {
        if (matrix.getWidth() != other.getWidth() || matrix.getHeight() != other.getHeight()) {
            return false;
        }
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                if (!(Math.abs(matrix.get(y, x) - other.get(y, x)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(@NotNull FloatMxN matrix, float epsilon) {
        for (int i = 0; i < matrix.getWidth(); ++i) {
            for (int j = 0; j < matrix.getHeight(); ++j) {
                if (i == j && Math.abs(matrix.get(i, j) - 1.0f) > epsilon) {
                    return false;
                }
                if (i == j || !(Math.abs(matrix.get(i, j) - 0.0f) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static <M extends Matrix> String toString(@NotNull M matrix, @NotNull String name, @NotNull MatrixGetter<M> getter) {
        return Matrix.toString(matrix, name, getter, 2);
    }

    @NotNull
    public static <M extends Matrix> String toString(@NotNull M matrix, @NotNull String name, @NotNull MatrixGetter<M> getter, int visibleDigits) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(matrix.getWidth()).append("x").append(matrix.getHeight()).append(":\n[\n");
        for (int y = 0; y < matrix.getHeight(); ++y) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                sb.append(String.format(" % 10." + visibleDigits + "f ", ((Number)getter.get(matrix, y, x)).doubleValue()));
            }
            if (y == matrix.getHeight() - 1) continue;
            sb.append("\n");
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    default public int getMemberCount() {
        return this.getWidth() * this.getHeight();
    }

    default public int positionToIndex(int y, int x) {
        return this.getMemoryLayout().positionToIndex(this.getWidth(), this.getHeight(), y, x);
    }

    public int getWidth();

    public int getHeight();

    @Override
    public boolean isArrayBacked();

    @Override
    public boolean isBufferBacked();

    @NotNull
    public MatrixMemoryLayout getMemoryLayout();

    public void setMemoryLayout(@NotNull MatrixMemoryLayout var1);

    @Override
    default public boolean isView() {
        return false;
    }

    @FunctionalInterface
    public static interface MatrixGetter<M extends Matrix> {
        @NotNull
        public Object get(@NotNull M var1, int var2, int var3);
    }

    public static interface View
    extends Matrix {
        public static int @NotNull [] matrixPosMappingToIndexMapping(@NotNull Matrix original, int @NotNull [] mapping) {
            int[] indexMapping = new int[mapping.length / 2];
            for (int i = 0; i < indexMapping.length; ++i) {
                indexMapping[i] = original.positionToIndex(mapping[i * 2], mapping[i * 2 + 1]);
            }
            return indexMapping;
        }

        @Override
        default public int positionToIndex(int y, int x) {
            return MatrixMemoryLayout.ROW_MAJOR.positionToIndex(this.getWidth(), this.getHeight(), y, x);
        }
    }
}

