/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix;

import de.linusdev.lutils.math.matrix.abstracts.floatn.FloatMxN;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MatrixMemoryLayout {
    ROW_MAJOR{

        @Override
        public int positionToIndex(int width, int height, int y, int x) {
            return y * width + x;
        }

        @Override
        public void fillOfRowMajorArray(@NotNull FloatMxN matrix, float[] data) {
            for (int i = 0; i < data.length; ++i) {
                matrix.put(i, data[i]);
            }
        }
    }
    ,
    COLUMN_MAJOR{

        @Override
        public int positionToIndex(int width, int height, int y, int x) {
            return x * height + y;
        }

        @Override
        public void fillOfRowMajorArray(@NotNull FloatMxN matrix, float[] data) {
            for (int x = 0; x < matrix.getWidth(); ++x) {
                for (int y = 0; y < matrix.getHeight(); ++y) {
                    matrix.put(y, x, data[ROW_MAJOR.positionToIndex(matrix.getWidth(), matrix.getHeight(), y, x)]);
                }
            }
        }
    };


    public abstract int positionToIndex(int var1, int var2, int var3, int var4);

    public abstract void fillOfRowMajorArray(@NotNull FloatMxN var1, float[] var2);
}

