/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.special;

import de.linusdev.lutils.math.VMath;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float4x4;
import de.linusdev.lutils.math.special.TransRotMatrix;
import de.linusdev.lutils.math.vector.Vector;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float3;
import org.jetbrains.annotations.NotNull;

public class CameraMatrix
extends TransRotMatrix {
    @NotNull
    protected final Float4x4 backingViewMatrix;
    @NotNull
    protected Float3 worldUp = DEFAULT_UP;
    @NotNull
    protected final Float3 viewDirectionBacked;
    @NotNull
    protected final Float3 screenUpBacked;
    @NotNull
    protected final Float3 screenRightBacked;

    public CameraMatrix(@NotNull Float4x4 backingMatrix, @NotNull Float4x4 backingViewMatrix) {
        super(backingMatrix);
        this.backingViewMatrix = backingViewMatrix;
        this.backingViewMatrix.put(3, 3, 1.0f);
        this.viewDirectionBacked = backingMatrix.createFloat3View(0, 2, 1, 2, 2, 2);
        this.screenUpBacked = backingMatrix.createFloat3View(0, 1, 1, 1, 2, 1);
        this.screenRightBacked = backingMatrix.createFloat3View(0, 0, 1, 0, 2, 0);
    }

    public void setWorldUp(@NotNull Float3 worldUp) {
        assert (Vector.isNormalized(worldUp, 1.0E-5f));
        this.worldUp = worldUp;
    }

    public void lookAt(@NotNull Float3 position) {
        VMath.subtract(this.positionView.xyz(), position, this.viewDirectionBacked);
        VMath.normalize(this.viewDirectionBacked, this.viewDirectionBacked);
        VMath.cross(this.worldUp, this.viewDirectionBacked, this.screenRightBacked);
        VMath.normalize(this.screenRightBacked, this.screenRightBacked);
        VMath.cross(this.viewDirectionBacked, this.screenRightBacked, this.screenUpBacked);
        VMath.normalize(this.screenUpBacked, this.screenUpBacked);
    }

    public void calculateViewMatrix() {
        VMath.transpose3x3(this.backingMatrix, this.backingViewMatrix);
        this.backingViewMatrix.put(0, 3, VMath.dot(this.screenRightBacked, this.positionView.xyz()));
        this.backingViewMatrix.put(1, 3, VMath.dot(this.screenUpBacked, this.positionView.xyz()));
        this.backingViewMatrix.put(2, 3, VMath.dot(this.viewDirectionBacked, this.positionView.xyz()));
        assert (this.backingViewMatrix.get(3, 3) == 1.0f);
        assert (this.backingViewMatrix.get(3, 0) == 0.0f);
        assert (this.backingViewMatrix.get(3, 1) == 0.0f);
        assert (this.backingViewMatrix.get(3, 2) == 0.0f);
    }

    @NotNull
    public Float4x4 viewMatrix() {
        return this.backingViewMatrix;
    }

    @Override
    public void setRotation(float angle, @NotNull Float3 axis) {
        super.setRotation(angle, axis);
    }

    @Override
    public void setRotation(float yaw, float pitch, float roll) {
        super.setRotation(yaw, pitch, roll);
    }

    @Override
    public void addRotation(float yaw, float pitch, float roll) {
        super.addRotation(yaw, pitch, roll);
    }
}

